eb_player = {}

core.register_on_joinplayer(function(player)
	player:set_properties({
		collisionbox = { -0.4, 0, -0.4, 0.4, 1.8, 0.4 },
		selectionbox = { -0.4, 0, -0.4, 0.4, 1.8, 0.4 },
		visual = "upright_sprite",
		visual_size = { x = 0.8, y = 1.8, z = 0.8 },
		textures = {
			-- No player model or texture;
			-- this game only allows the first-person camera
			"blank.png",
			"blank.png",
		},
		stepheight = 0.6,
		shaded = true,
	})
	player:set_fov(60)
	-- Restrict to first-person camera (Luanti 5.12.0 onwards)
	if player.set_camera then
		player:set_camera({mode = "first"})
	end
	local inv = player:get_inventory()
	inv:set_size("craft", 0)
	inv:set_size("craftpreview", 0)
	player:set_formspec_prepend(
		"bgcolor[#00000000]"..
		"background9[0,0;9,9;eb_player_formspec_bg.png;true;4]"..
		"style_type[button;bgimg=eb_player_button_bg.png;bgimg_middle=2;textcolor=#ffffff]"..
		"style_type[button:hovered;bgimg=eb_player_button_bg.png^[screen:#444444;bgimg_middle=2;textcolor=#ffffff]"..
		"style_type[button:pressed;bgimg=eb_player_button_bg.png^[screen:#999999;bgimg_middle=2;textcolor=#000000]"
	)

	eb_sky.init_sky()
	eb_sky.set_sky("gray")
end)

eb_player.set_editor_inventory = function(player)
	local inv = player:get_inventory()
	player:hud_set_hotbar_itemcount(10)
	inv:set_size("main", 40)
	player:set_inventory_formspec("formspec_version[7]"..
		"size[13.15,5.75]"..
		"list[current_player;main;0.5,0.5;10,4;]"
	)
	player:hud_set_flags({hotbar=true})
end

eb_player.set_play_inventory = function(player)
	local inv = player:get_inventory()
	player:hud_set_hotbar_itemcount(1)
	inv:set_size("main", 1)
	player:set_inventory_formspec("")
	player:hud_set_flags({hotbar=false})
end
