local F = minetest.formspec_escape
local S = minetest.get_translator("glitch_abilities")

glitch_abilities.register_ability("glitch:stepheight", {
	description = S("Super Slope Sliding"),
	explanation = S("Can slide up tall slopes"),
	-- With ability: Can climb tall slopes;
	-- without abolity: Can climb small slopes.
	activate = function(player)
		-- High enough for small+large slope;
		-- too low for climbing a slab.
		player:set_properties({stepheight = 0.130})
	end,
	deactivate = function(player)
		if not glitch_editor.is_active() then
			-- High enough for small slope;
			-- too low for tall slope and slab..
			player:set_properties({stepheight = 0.063})
		end
	end,
})

--[[
Experimental ability (for dev only).
Player is not supposed to jump normally.

glitch_abilities.register_ability("glitch:jump", {
	description = S("Jumping"),
	explanation = S("Can jump"),
	controls = S("Press Jump key"),
	activate = function(player)
		playerphysics.add_physics_factor(player, "jump", "ability_jump", 1)
	end,
	deactivate = function(player)
		if not glitch_editor.is_active() then
			playerphysics.add_physics_factor(player, "jump", "ability_jump", 0)
		end
	end,
})
]]

glitch_abilities.register_ability("glitch:slide", {
	description = S("Sliding"),
	explanation = S("Can slide on flat ground and small slopes"),
	controls = S("Press Up/Down/Left/Right key"),
	activate = function(player)
		playerphysics.add_physics_factor(player, "speed", "ability_slide", 1)
	end,
	deactivate = function(player)
		if not glitch_editor.is_active() then
			playerphysics.add_physics_factor(player, "speed", "ability_slide", 0)
		end
	end,
})
glitch_abilities.register_ability("glitch:powerslide", {
	description = S("Power-Sliding"),
	explanation = S("Can use small speed boosts on the floor"),
	controls = S("Press Aux1 + Up"),
	-- Handled in powerslide.lua
})

glitch_abilities.register_ability("glitch:carry", {
	description = S("Carrying"),
	explanation = S("Can carry a single item"),
	activate = function(player)
		if not glitch_editor.is_active() then
			local inv = player:get_inventory()
			inv:set_size("main", 1)
			player:hud_set_flags({
				hotbar = true,
				wielditem = true,
			})
			player:hud_set_hotbar_itemcount(1)
		end
	end,
	deactivate = function(player)
		if not glitch_editor.is_active() then
			local inv = player:get_inventory()
			inv:set_size("main", 0)
			player:hud_set_flags({
				hotbar = false,
				wielditem = false,
			})
			player:hud_set_hotbar_itemcount(1)
			glitch_inventory_formspec.set_value(player, "has_carry_ability", false)
			glitch_inventory_formspec.update(player)
		end
	end,
})

glitch_abilities.register_ability("glitch:climb", {
	description = S("Climbing"),
	explanation = S("Can climb at certain places"),
	controls = S("Press Jump to climb up; press Sneak key to climb down"),
	needs_level_update = true,
})

glitch_abilities.register_ability("glitch:jumppad", {
	description = S("Launching"),
	explanation = S("Can use launchpads"),
	controls = S("Hold down Aux1 or Jump key on a launchpad"),
})
