-- Code for special move abilities, inlcuding:

-- Powerslide ability:
-- Allow powerslide with Aux1 + Up key.
-- Jump key MUST NOT be pressed (this is a workaround for awkwards physics behavior)
-- This gives a quick horitontal speed impulse.
-- Player must be on the floor for this to work.

-- Jump pad ability
-- Aux1 on a jumppad makes you jump
-- (param2 determines jump strength)


-- How fast the speed boost is
local POWERSLIDE_VELOCITY = 19

-- Usage cooldown in seconds
local COOLDOWN = 1.25

local cooldowns = {}

minetest.register_globalstep(function(dtime)
	local players = minetest.get_connected_players()
	for p=1, #players do
		local player = players[p]
		local name = player:get_player_name()
		if not cooldowns[name] then
			cooldowns[name] = COOLDOWN
		end
		cooldowns[name] = cooldowns[name] - dtime
		if cooldowns[name] <= 0 then
			local ctrl = player:get_player_control()
			local ability_used = false
			do
				-- Jump pad
				if (ctrl.aux1 or ctrl.jump) and glitch_abilities.has_ability(player, "glitch:jumppad") then
					local below = vector.add(player:get_pos(), vector.new(0, -1, 0))
					local node = minetest.get_node(below)
					local vel = player:get_velocity()
					if node.name == "glitch_nodes:jumppad" and math.abs(vel.y) < 0.001 then
						local yvel = node.param2 / 4
						player:add_velocity({x=0, y=yvel, z=0})
						minetest.sound_play({name="glitch_abilities_jumppad", gain=0.8}, {pos=below}, true)
						cooldowns[name] = COOLDOWN
						ability_used = true
					end
				end
				-- Powerslide
				if (not ability_used) and (ctrl.aux1 and ctrl.up and not ctrl.jump) and glitch_abilities.has_ability(player, "glitch:powerslide") then
					-- Check if we stand on solid ground (no powerslide in mir-air, please!)
					local pos_here = player:get_pos()
					local node_here = minetest.get_node(pos_here)
					local def_here = minetest.registered_nodes[node_here.name]

					local pos_below = vector.add(pos_here, vector.new(0,-0.5,0))
					local node_below = minetest.get_node(pos_below)
					local def_below = minetest.registered_nodes[node_below.name]
					local floor_ok = (def_below and def_below.walkable) or (pos_here and pos_here.walkable)
					local here_ok = node_here.name ~= "glitch_nodes:resetter"
					local vel_ok = math.abs(player:get_velocity().y) < 0.001

					if floor_ok and here_ok and vel_ok then
						-- Powerslide!
						local yaw = player:get_look_horizontal()
						local dir = minetest.yaw_to_dir(yaw)
						local vel = vector.multiply(dir, POWERSLIDE_VELOCITY)
						player:add_velocity(vel)
						minetest.sound_play({name="glitch_abilities_powerslide", gain=0.8}, {object=player}, true)

						minetest.add_particlespawner({
							amount = 12,
							exptime = { min = 0.9, max = 1.0 },
							size = 0.8,
							time = 0.5,
							texture = {
								name = "glitch_abilities_particle_powerslide.png",
								alpha_tween = { start = 0.85, 1, 0 },
							},
							pos = { min=vector.new(-0.4, -0.4, -0.4), max=vector.new(0.4,-0.3,0.4) },
							vel = { min=vector.new(-0.1,0.01,-0.1), max=vector.new(0.1,1.2,0.1)},
							acc = { min=vector.new(0,0,0), max=vector.new(0,0,0) },
							drag = vector.new(1, 1, 1),
							attached = player,
						})

						cooldowns[name] = COOLDOWN
						ability_used = true
					end
				end
			end
		end
	end
end)

minetest.register_on_leaveplayer(function(player)
	local name = player:get_player_name()
	cooldowns[name] = nil
end)
