local S = minetest.get_translator("hades_liquidtanks")

local tanks = {
	{ "water", S("Glass Tank with Water"), "hades_liquidtanks_tank.png", "hades_core:water_source", S("Punch to empty the tank") },
}

local PARAM2_FULL = 63

local node_to_tank = {}
for b=1, #tanks do
	local data = tanks[b]
	local tank = "hades_liquidtanks:tank_"..data[1]
	local nodename = data[4]
	node_to_tank[nodename] = tank -- liquid source
	node_to_tank["hades_liquidtanks:tank_"..data[1]] = tank -- filled tank node
end

for b=1, #tanks do
	local tank = tanks[b]
	local waterdef = minetest.registered_nodes[tank[4]]
	local watertile = waterdef.tiles[1]
	minetest.register_node(
		"hades_liquidtanks:tank_"..tank[1],
		{
			description = tank[2],
			_tt_help = tank[5],

			drawtype = "glasslike_framed",
			paramtype2 = "glasslikeliquidlevel",
			place_param2 = PARAM2_FULL,
			tiles = {
				"hades_liquidtanks_tank.png",
			},
			special_tiles = {
				watertile,
			},
			paramtype = "light",
			is_ground_content = false,
			sounds = hades_sounds.node_sound_glass_defaults(),
			liquids_pointable = true,
			groups = { tank = 2, tank_water = 1, cracky = 3, oddly_breakable_by_hand = 3 },
			on_use = function(itemstack, user, pointed_thing)
				local inv=user:get_inventory()
				if pointed_thing.type ~= "node" then
					return itemstack
				end
	
				local pos = pointed_thing.above
				local above_node = minetest.get_node(pointed_thing.above)
				local under_node = minetest.get_node(pointed_thing.under)
				local above_nodedef = minetest.registered_nodes[above_node.name]
				local under_nodedef = minetest.registered_nodes[under_node.name]

				if under_nodedef and under_nodedef.buildable_to then
					pos=pointed_thing.under
				end

				local water_placed = false
				if minetest.get_item_group(under_node.name, "tank") ~= 0 then
					-- Pour water into tank node
					minetest.set_node(pointed_thing.under, {name = "hades_liquidtanks:tank_"..tank[1], param2 = PARAM2_FULL})
					minetest.sound_play({name="hades_liquidtanks_fill_water"}, {pos=pos}, true)
					water_placed = true
				elseif not above_nodedef.walkable and above_nodedef.buildable_to then
					-- Place water source node
					minetest.add_node(pos, {name = tank[4]})
					minetest.sound_play({name="default_place_node_water", gain=0.5}, {pos=pos}, true)
					water_placed = true
				end

				if water_placed then
					-- Handle inventory stuff
					if not minetest.is_creative_enabled(user:get_player_name()) then
						if itemstack:get_count() == 1 then
							itemstack:set_name("hades_liquidtanks:tank")
						elseif inv:room_for_item("main", {name="hades_liquidtanks:tank"}) then
							itemstack:take_item()
							inv:add_item("main", "hades_liquidtanks:tank")
						else
							itemstack:take_item()
							local pos = user:get_pos()
							pos.y = math.floor(pos.y + 0.5)
							minetest.add_item(pos, "hades_liquidtanks:tank")
						end
					end
				end

				return itemstack
			end
	})
end

minetest.register_node(
	"hades_liquidtanks:tank",
	{
		description = S("Glass Tank"),
		_tt_help = S("Punch to collect a water source"),

		drawtype = "glasslike_framed",
		paramtype2 = "glasslikeliquidlevel",
		tiles = {
			"hades_liquidtanks_tank.png",
		},
		special_tiles = {
			"blank.png",
		},
		place_param2 = 0,
		sounds = hades_sounds.node_sound_glass_defaults(),
		paramtype = "light",
		liquids_pointable = true,
		groups = { tank = 1, cracky = 3, oddly_breakable_by_hand = 3 },
		on_use = function(itemstack, user, pointed_thing)
			if pointed_thing.type ~= "node" then return end

			local pos_protected = minetest.get_pointed_thing_position(pointed_thing, true)
			if minetest.is_protected(pos_protected, user:get_player_name()) and
					not minetest.check_player_privs(user, "protection_bypass") then
				minetest.record_protection_violation(pos_protected, user:get_player_name())
				return
			end

			local nodename = minetest.get_node(pointed_thing.under).name

			local replace_tank = function(itemstack, new_tank)
				if minetest.is_creative_enabled(user:get_player_name()) then
					-- no-op
				elseif itemstack:get_count() == 1 then
					itemstack:set_name(new_tank)
				else
					itemstack:take_item()

					local inv = user:get_inventory()

					local tank = node_to_tank[nodename]
					if not tank then
						return itemstack
					end

					if inv:room_for_item("main", {name=tank}) then
						inv:add_item("main", tank)
					else
						local pos = user:get_pos()
						pos.y = math.floor(pos.y + 0.5)
						minetest.add_item(pos, tank)
					end
				end
				local oldnode = minetest.get_node(pointed_thing.under)
				if minetest.get_item_group(oldnode.name, "tank") == 2 then
					-- Pick up liquid from tank node
					minetest.set_node(pointed_thing.under, {name="hades_liquidtanks:tank", param2 = oldnode.param2 % 32})
					minetest.sound_play({name="hades_liquidtanks_take_water"}, {pos=pointed_thing.under}, true)
				else
					-- Pick up liquid source node and fill it into tank
					minetest.remove_node(pointed_thing.under)
					minetest.sound_play({name="hades_liquidtanks_fill_water"}, {pos=pointed_thing.under}, true)
				end
				return itemstack
			end

			local tank = node_to_tank[nodename]
			if tank then
				itemstack = replace_tank(itemstack, tank)
			end

			return itemstack
		end,
	}
)

minetest.register_craft({
	recipe = {
		{ "hades_core:tin_ingot", "hades_core:tin_ingot", "hades_core:tin_ingot" },
		{ "hades_core:tin_ingot", "hades_core:glass", "hades_core:tin_ingot" },
		{ "hades_core:tin_ingot", "hades_core:tin_ingot", "hades_core:tin_ingot" },
	},
	output = "hades_liquidtanks:tank",
})
