# Information for modders and other developers

If you want to write a mod for this game, please read this file carefully.

Hades Revisited is still in the *alpha* stage, which means its codebase and features may change radically,
even in a compatibility-breaking manner. Also, the first priority of this game is first to create
a good game in the first place. Support for mods comes second.

But there are good news: The codebase is now stable enough that I expect the number of huge breaking
changes go down in time. The game is now stable enough that I can make a first careful promise.

## Wuzzy’s Compatibility Promise

I make a *careful promise* that all the following mods are *probably* future-compatible from version 0.17.0 on:

* `hades_bounds`
* `hades_chests`
* `hades_cloth`
* `hades_commands`
* `hades_compass`
* `hades_coords`
* `hades_craftguide`
* `hades_death_messages`
* `hades_doors`
* `hades_drippingwater`
* `hades_dye`
* `hades_env_sounds`
* `hades_equipment`
* `hades_fences`
* `hades_fertilizer`
* `hades_flowerpots`
* `hades_furnaces`
* `hades_grass`
* `hades_gui`
* `hades_itemshow`
* `hades_lamps`
* `hades_liquidtanks`
* `hades_localize`
* `hades_materials`
* `hades_player`
* `hades_seasons`
* `hades_seeds`
* `hades_skins`
* `hades_sky`
* `hades_sounds`
* `hades_stairs`
* `hades_tiles`
* `hades_trees`
* `hades_tt`
* `hades_vessels`
* `hades_vines`
* `hades_walls`
* `hades_wardrobes`
* `hades_waterplants`
* `hades_windows`
* `playerphysics`
* `show_wielded_item`
* `tt`

“probably” means that I will try my best to no introduce any breaking changes
with these mods, but it is not a 100% guarantee. Let’s say it’s a 90% guarantee.
First I try my best to avoid breaking changes as much as possible (for these mods)
and only when I see no alternative, I may introduce one, and even then I try to
minimize the impact for modders.

I promise to avoid *big* breaking changes for these mods (such as removing
hundreds of nodes) until a major release. So it should be generally safe to depend
on these mods now. However, the documentation is still very sparse, so be prepared
to read lots of code.

**ALL MODS NOT LISTED ABOVE ARE SUBJECT TO RADICAL CHANGES!**

If a mod is not listed above, there is no guarantee whatsoever it is safe to depend on
it and write mods for it. You still can do it, of course, but be warned it may be likely
to break in future versions so you have to keep up with development.

Carefully read the release notes of this game when a new release comes out because
they always contain important compatibility notes as well.

## Other information

In `GROUPS.md`, there’s a list of groups used in this game. Make sure to use the
conventions in this list when creating new items or nodes.
