local S = minetest.get_translator("hades_refruit")

-- hades_refruit
-- Makes fruit regrow on the trees.
hades_refruit = {}

function hades_refruit.add_hades_refruit(id, def)
	local ndef = minetest.registered_nodes[def.fruit_itemstring]
	local groups = ndef.groups
	if not groups then
		groups = {}
	else
		groups = table.copy(ndef.groups)
	end
	local groups_fruit
	groups_fruit = table.copy(groups)
	groups_fruit.fruit_regrow = 3


	local bud_itemstring = "hades_refruit:bud_"..id
	local flower_itemstring = "hades_refruit:flower_"..id

	minetest.override_item(def.fruit_itemstring, {
		groups = groups_fruit,
		place_param2 = 1,
		after_dig_node = function(pos, oldnode, oldmetadta, digger)
			if oldnode.name == def.fruit_itemstring then
				if oldnode.param2 ~= 0 then
					return
				end
				minetest.set_node(pos, {name = "hades_refruit:bud_"..id})
			else 
				return
			end
		end,
		node_dig_prediction = bud_itemstring,
		_hades_grows_from = def.flower_itemstring,
		_hades_magic_next = bud_itemstring,
		_hades_trees_trunk = def.trunk,
	})

	minetest.override_item(def.sapling_itemstring, {
		_hades_fruit = bud_itemstring,
	})

	local desc_trunk = ItemStack(def.trunk):get_short_description()
	local desc_neighbor = ItemStack(def.neighbors[1]):get_short_description()
	local desc_seasons
	if def.seasons then
		if #def.seasons == hades_seasons.SEASONS then
			desc_seasons = S("All seasons")
		elseif #def.seasons == 1 then
			desc_seasons = S("Season: @1", hades_seasons.SEASON_NAMES[def.seasons[1]])
		else
			local list_seasons = ""
			for s=1, #def.seasons do
				table.insert(list_seasons, hades_seasons.SEASON_NAMES[def.seasons[s]])
			end
			desc_seasons = S("Seasons: @1",
				--~ list separator for list of seasons
				table.concat(list_seasons, S(", ")))
		end
	else
		desc_seasons = S("All seasons")
	end

	local desc_fruit = ItemStack(def.fruit_itemstring):get_short_description()
	local desc_trunk = ItemStack(def.trunk):get_short_description()

	local bud_tt = desc_seasons.."\n"..
		S("Grows to: @1", def.flower_description).."\n"..
		S("Needs @1 to survive", desc_trunk).."\n"..
		S("Needs @1 to grow", desc_neighbor)
	local flower_tt = desc_seasons.."\n"..
		S("Grows to: @1", desc_fruit).."\n"..
		S("Needs @1 to survive", desc_trunk).."\n"..
		S("Needs @1 to grow", desc_neighbor)

	minetest.register_node(bud_itemstring, {
		description = def.bud_description,
		_tt_help = bud_tt,
		drawtype = ndef.drawtype,
		tiles = {"hades_refruit_bud_"..id..".png"},
		inventory_image = "hades_refruit_bud_"..id..".png",
		wield_image = "hades_refruit_bud_"..id..".png",
		paramtype = "light",
		sunlight_propagates = true,
		walkable = false,
		floodable = true,
		selection_box = {
			type = "fixed",
			fixed = def.bud_selbox,
		},
		groups = {fruit_regrow=1, snappy=2,oddly_breakable_by_hand=3,flammable=2,leafdecay=3,leafdecay_drop=1},
		drop = def.bud_drop or {},
		sounds = hades_sounds.node_sound_leaves_defaults(),
		_hades_grows_to = flower_itemstring,
		_hades_magic_next = flower_itemstring,
		_hades_trees_trunk = def.trunk,
	})
	minetest.register_node(flower_itemstring, {
		description = def.flower_description,
		_tt_help = flower_tt,
		drawtype = ndef.drawtype,
		tiles = {"hades_refruit_flower_"..id..".png"},
		inventory_image = "hades_refruit_flower_"..id..".png",
		wield_image = "hades_refruit_flower_"..id..".png",
		paramtype = "light",
		sunlight_propagates = true,
		walkable = false,
		floodable = true,
		selection_box = {
			type = "fixed",
			fixed = def.flower_selbox,
		},
		groups = {fruit_regrow=2, snappy=2,oddly_breakable_by_hand=3,flammable=2,leafdecay=3,leafdecay_drop=1},
		drop = def.flower_drop or {},
		sounds = hades_sounds.node_sound_leaves_defaults(),
		_hades_grows_from = bud_itemstring,
		_hades_grows_to = def.fruit_itemstring,
		_hades_magic_next = def.fruit_itemstring,
		_hades_trees_trunk = def.trunk,
	})

	local is_in_season = function()
		if not def.seasons then
			return true
		end
		local season = hades_seasons.get_season()
		if not season then
			return nil
		end
		for s=1, #def.seasons do
			if season == def.seasons[s] then
				return true
			end
		end
		return false
	end

	-- Grow bud to flower
	minetest.register_abm({
		label = "Grow "..bud_itemstring.." to "..flower_itemstring,
		nodenames = {"hades_refruit:bud_"..id},
		neighbors = def.neighbors,
		interval = def.bud_interval,
		chance = def.bud_chance,
		action = function(pos, node)
			if is_in_season() == true then
				minetest.set_node(pos, {name="hades_refruit:flower_"..id})
			end
		end,
	})

	-- Grow flower to fruit, or degrow to bud if out-of-season
	minetest.register_abm({
		label = "Grow or degrow "..flower_itemstring.." to "..def.fruit_itemstring,
		nodenames = {"hades_refruit:flower_"..id},
		neighbors = def.neighbors,
		interval = def.flower_interval,
		chance = def.flower_chance,
		action = function(pos, node)
			local in_season = is_in_season()
			if in_season == true then
				-- grow if in-season
				minetest.set_node(pos, {name=def.fruit_itemstring})
			elseif in_season == false then
				-- degrow if out-of-season
				minetest.set_node(pos, {name=bud_itemstring})
			end
		end,
	})

	-- Drop fruit if out of season
	if def.fruit_interval and def.fruit_chance then
		minetest.register_abm({
			label = "Drop out-of-season "..def.fruit_itemstring,
			nodenames = {def.fruit_itemstring},
			interval = def.fruit_interval,
			chance = def.fruit_chance,
			action = function(pos, node)
				if is_in_season() == false then
					-- degrow to bud and drop fruit as item
					minetest.set_node(pos, {name=bud_itemstring})
					minetest.add_item(pos, def.fruit_itemstring)
				end
			end,
		})
	end

end


local stick_drop = function(rarity)
	return {
		max_items = 1,
		items = {
			{
				items = {'hades_core:stick'},
				rarity = rarity,
			},
			{
				items = {'hades_core:stick'},
				rarity = rarity
			}
		}
	}
end

-- TODO: Balance out the season availability of fruit

hades_refruit.add_hades_refruit("apple", {
	-- available in all seasons because this is the starter fruit
	-- TODO: Restrict to fall later
	fruit_itemstring = "hades_trees:apple",
	sapling_itemstring = "hades_trees:sapling",
	bud_description = S("Apple Bud"),
	flower_description = S("Apple Flower"),
	bud_drop = stick_drop(99),
	flower_drop = stick_drop(99),
	bud_interval = 34,
	bud_chance = 10,
	flower_interval = 33,
	flower_chance = 60,
	fruit_interval = 33,
	fruit_chance = 20,
	neighbors = {"hades_trees:leaves"},
	trunk = "hades_trees:tree",
	bud_selbox = {-0.1875, -0.3125, -0.1875, 0.1875, 0.3125, 0.1875},
	flower_selbox = {-0.1875, -0.3125, -0.1875, 0.1875, 0.3125, 0.1875},
})

hades_refruit.add_hades_refruit("olive", {
	fruit_itemstring = "hades_trees:olive",
	sapling_itemstring = "hades_trees:olive_sapling",
	bud_description = S("Olive Bud"),
	flower_description = S("Olive Flower"),
	bud_drop = stick_drop(99),
	flower_drop = stick_drop(76),
	bud_interval = 35,
	bud_chance = 10,
	flower_interval = 34,
	flower_chance = 60,
	fruit_interval = 34,
	fruit_chance = 20,
	neighbors = {"hades_trees:olive_leaves"},
	trunk = "hades_trees:tree",
	bud_selbox = {-2/16, 1/16, -2/16, 2/16, 0.5, 2/16},
	flower_selbox = {-4/16, -1/16, -4/16, 4/16, 0.5, 4/16},
	seasons = { hades_seasons.SEASON_SUMMER },
})

hades_refruit.add_hades_refruit("orange", {
	fruit_itemstring = "hades_trees:orange",
	sapling_itemstring = "hades_trees:orange_sapling",
	bud_description = S("Orange Bud"),
	flower_description = S("Orange Flower"),
	bud_interval = 34,
	bud_chance = 10,
	flower_interval = 33,
	flower_chance = 60,
	fruit_interval = 33,
	fruit_chance = 20,
	neighbors = {"hades_trees:orange_leaves"},
	trunk = "hades_trees:orange_tree",
	bud_selbox = {-0.1875, -0.4375, -0.1875, 0.1875, 0.25, 0.1875},
	flower_selbox = {-0.1875, -0.4375, -0.1875, 0.1875, 0.25, 0.1875},
	seasons = { hades_seasons.SEASON_SPRING },
})

hades_refruit.add_hades_refruit("banana", {
	fruit_itemstring = "hades_trees:banana",
	sapling_itemstring = "hades_trees:banana_sapling",
	bud_description = S("Banana Bud"),
	flower_description = S("Banana Flower"),
	bud_interval = 35,
	bud_chance = 10,
	flower_interval = 34,
	flower_chance = 60,
	fruit_interval = 34,
	fruit_chance = 20,
	neighbors = {"hades_trees:banana_leaves"},
	trunk = "hades_trees:tree",
	bud_selbox = {-0.1875, -0.4375, -0.1875, 0.1875, 0.25, 0.1875},
	flower_selbox = {-0.1875, -0.4375, -0.1875, 0.1875, 0.25, 0.1875},
	seasons = { hades_seasons.SEASON_SUMMER },
})

hades_refruit.add_hades_refruit("cocoa", {
	fruit_itemstring = "hades_trees:cocoa_pod",
	sapling_itemstring = "hades_trees:cocoa_sapling",
	bud_description = S("Cocoa Bud"),
	flower_description = S("Cocoa Flower"),
	bud_interval = 35,
	bud_chance = 10,
	flower_interval = 34,
	flower_chance = 60,
	fruit_interval = 34,
	fruit_chance = 20,
	neighbors = {"hades_trees:jungle_leaves"},
	trunk = "hades_trees:jungle_tree",
	bud_selbox = {-0.1875, -0.25, -0.1875, 0.1875, 0.375, 0.1875},
	flower_selbox = {-0.1875, -0.1875, -0.1875, 0.1875, 0.5, 0.1875},
	seasons = { hades_seasons.SEASON_FALL },
})

hades_refruit.add_hades_refruit("coconut", {
	fruit_itemstring = "hades_trees:coconut",
	sapling_itemstring = "hades_trees:coconut_sapling",
	bud_description = S("Coconut Bud"),
	flower_description = S("Coconut Flower"),
	bud_interval = 35,
	bud_chance = 10,
	flower_interval = 34,
	flower_chance = 60,
	fruit_interval = 34,
	fruit_chance = 60,
	neighbors = {"hades_trees:jungle_leaves"},
	trunk = "hades_trees:jungle_tree",
	bud_selbox = {-2/16, -6/16, -2/16, 2/16, 3/16, 2/16},
	flower_selbox = {-5/16, -7/16, -5/16, 5/16, 7/16, 5/16},
	seasons = { hades_seasons.SEASON_SPRING },
})

