# `hades_ghostinv` API

## Introduction
`hades_ghostinv` allows you to move the entire player inventory into different inventory lists (the “ghost inventory”), and to restore them afterwards.

This API was created for `hades_revisited` because there needs to be a simple way to clear/restore the player inventory on entering/leaving the simulation. It has NOT been vetted for any other use case so far, however, so take with care. 

## `hades_ghostinv.declare_inventory = function(name, detached_list)`
Declares an inventory list to be “ghostable”. A ghostable inventory list will be moved into the ghost inventory when `hades_ghostinv.ghostify_inventories` is called.

If `detached_list` is not set, then the ghostable inventory list is part of the normal player inventory and the ghostable inventory list name must be specified in `name`.

If `detached_list` is set to a string, then the inventory list is part of a detached inventory which MUST have the name `<player_name>_<name>`, where `<player_name>` is the name of the player to which the detached inventory belongs to and `<name>` is the `name` argument of this function.

Note this must apply to to all players equally to function.

Initially, the inventory lists `main` and `craft` are declared as part of the “ghostable” inventory.

## `hades_ghostinv.ghostify_inventories = function(player, ghost_prefix)`
This moves all inventory lists that were declares as “ghostable” to a ghost inventory.

When this function is called, each inventory list that was declared to be ghostable is cleared and the contents of each list (before the clearing) are moved to a new inventory list each, with the name `<ghost_prefix>_<original_name>`, where `<ghost_prefix>` is the `ghost_prefix` argument of this function and `<original_name>` is the original inventory list name.

`ghost_prefix` can be any valid string that would be valid for inventory list names. Make sure to choose a prefix that avoids name collisions! (Leading underscores are probably a good idea.)

## `hades_ghostinv.unghostify_inventories = function(player, ghost_prefix)`
This is the reverse operation of the previous function.

This function restores a “ghostified” inventory. The contents of the ghost inventory lists that were created with the function above are copied back to the original inventory list names. Also, to prevent data garbage, the ghost inventory lists will be removed (size set to 0). `ghost_prefix` must be the same string that was used in `hades_ghostinv.ghostify_inventories` 

Calling this function when `hades_ghostinv.ghostify_inventories` was not called before will lead to undefined behavior, so don’t do that.
