local S = minetest.get_translator("hades_trees")

local function generate_appletree(pos, check_light, trunk, leaves, replacement)
	if not trunk then
		trunk = "hades_trees:tree"
	end
	if not leaves then
		leaves = "hades_trees:leaves"
	end
	hades_trees.generate_applelike_tree(pos, check_light, trunk, leaves, replacement)
end

hades_trees.register_sapling("sapling", {
	description = S("Apple Sapling"),
	image = "default_sapling.png",
	selbox = {-0.3, -0.5, -0.3, 0.3, 0.35, 0.3},
	grow = generate_appletree,
	fruit = "hades_trees:apple",
	fruit_chance = 9,
})
hades_trees.register_seed("seed", {
	description = S("Apple Seed"),
	image = "hades_trees_seed.png",
	_hades_grows_to = "hades_trees:sapling",
})

hades_trees.register_leaves("leaves", {
	description = S("Apple Leaves"),
	image = "hades_trees_apple_leaves_colorable.png",
	ash_fertilizer = 3,
	trunk = "hades_trees:tree",
	colorable = true,
	palette = "hades_trees_apple_leaves_palette.png",
	color_stereotype = "#60b555",
})
hades_trees.register_fruit("apple", {
	description = S("Apple"),
	drawtype = "plantlike",
	image = "default_apple.png",
	selbox = {-0.25, -0.375, -0.25, 0.25, 0.375, 0.25},
	satiation = 2,
})

hades_trees.register_grow_abms({
	label = "Grow apple sapling and seed",
	sapling = "hades_trees:sapling",
	seed = "hades_trees:seed",
	interval = 10,
	chance = 50,
})


