local S = minetest.get_translator("hades_trees")

local function generate_bananatree(pos, check_light, trunk, leaves, replacement)
	trunk = trunk or "hades_trees:tree"
	leaves = leaves or "hades_trees:banana_leaves"
	local config = {
		trunk_height = 3,
		leaves_start_height = 1,
		leaves_height = 3,
		leaves_outwards = 1,
		leaves_chance_numerator = 1,
		leaves_chance_denominator = 1,
	}
	hades_trees.generate_cuboid_tree(pos, check_light, trunk, leaves, replacement, nil, config)
end

hades_trees.register_leaves("banana_leaves", {
	description = S("Banana Leaves"),
	image = "hades_trees_banana_leaves_colorable.png",
	colorable = true,
	palette = "hades_trees_banana_leaves_palette.png",
	color_stereotype = "#43873b",
	ash_fertilizer = 3,
	trunk = "hades_trees:tree",
})
hades_trees.register_sapling("banana_sapling", {
	description = S("Banana Sapling"),
	image = "hades_trees_banana_sapling.png",
	selbox = {-0.3, -0.5, -0.3, 0.3, 0.35, 0.3},
	grow = generate_bananatree,
	fruit = "hades_trees:banana",
	fruit_chance = 9,
})
hades_trees.register_seed("banana_seed", {
	description = S("Banana Seed"),
	image = "hades_trees_banana_seed.png",
	_hades_grows_to = "hades_trees:banana_sapling",
})


hades_trees.register_fruit("banana", {
	description = S("Banana"),
	drawtype = "torchlike",
	image = "hades_trees_banana.png",
	selbox = {-4/16, -7/16, -4/16, 4/16, 6/16, 4/16},
	satiation = 2,
})


hades_trees.register_grow_abms({
	sapling = "hades_trees:banana_sapling",
	seed = "hades_trees:banana_seed",
	interval = 30,
	chance = 10,
})
