local S = minetest.get_translator("hades_trees")

local function generate_canvastree(pos, check_light, trunk, leaves)
	trunk = trunk or "hades_trees:canvas_tree"
	leaves = leaves or "hades_trees:canvas_leaves"
	local config = {
		trunk_height = 7,
		leaves_start_height = 3,
		leaves_height = 7,
		leaves_outwards = 2,
		leaves_chance_numerator = 4,
		leaves_chance_denominator = 5,
	}
	hades_trees.generate_cuboid_tree(pos, check_light, trunk, leaves, nil, nil, config)
end

hades_trees.register_trunk("canvas_tree", {
	--~ the 'canvas tree' is a special tree that produces paintable wood
	description = S("Canvas Tree Trunk"),
	tiles = {"hades_trees_canvas_tree_top.png", "hades_trees_canvas_tree_top.png", "hades_trees_canvas_tree.png"},
})
hades_trees.register_leaves("canvas_leaves", {
	--~ leaves of the 'canvas tree', a special tree that produces paintable wood
	description = S("Canvas Leaves"),
	image = "hades_trees_canvas_leaves_colorable.png",
	colorable = true,
	palette = "hades_trees_canvas_leaves_palette.png",
	color_stereotype = "#a3dcaf",
	ash_fertilizer = 0,
	drop_item = "hades_trees:canvas_seed",
	drop_rarity = 20,
	trunk = "hades_trees:canvas_tree",
})

hades_trees.register_bark("canvas_bark", {
	--~ bark of the 'canvas tree', a special tree that produces paintable wood
	description = S("Canvas Bark"),
	image = "hades_trees_canvas_tree.png",
})
hades_trees.register_sapling("canvas_sapling", {
	--~ the 'canvas tree' is a special tree that produces paintable wood
	description = S("Canvas Tree Sapling"),
	image = "hades_trees_canvas_sapling.png",
	selbox = {-0.3, -0.5, -0.3, 0.3, 0.35, 0.3},
	grow = generate_canvastree,
})
hades_trees.register_seed("canvas_seed", {
	description = S("Canvas Tree Seed"),
	image = "hades_trees_canvas_seed.png",
	_hades_grows_to = "hades_trees:canvas_sapling",
})

hades_trees.register_grow_abms({
	label = "Grow canvas tree sapling and seed",
	sapling = "hades_trees:canvas_sapling",
	seed = "hades_trees:canvas_seed",
	interval = 8,
	chance = 40,
})
