local pr_a -- PseudoRandom var

function hades_trees.grow_sapling(pos, check_light)
	local node = minetest.get_node(pos)
	local trunk, leaves, replacement
	-- Grow tree charred if sapling was close to lava
	local lava = minetest.find_node_near(pos, 1, "group:lava")
	if lava then
		trunk = "hades_trees:charred_tree"
		leaves = "hades_trees:burned_branches"
		replacement = {}
	else
		local ndef = minetest.registered_nodes[node.name]
		if ndef and ndef._hades_fruit and ndef._hades_fruit_chance then
			replacement = { name = ndef._hades_fruit, chance = ndef._hades_fruit_chance }
		end
	end

	local ndef = minetest.registered_nodes[node.name]
	if ndef and ndef._hades_grow_sapling then
		ndef._hades_grow_sapling(pos, check_light, trunk, leaves, replacement)
	end
end

local function check_node_light(pos, minlight, check)
	if check == false then
		return true
	end
	local l = minetest.get_node_light(pos)
	if not l or l < minlight then
		return false
	end
	return true
end

--[[
Generates a basic tree that has a round-ish shape.

pos: Position of tree base
check_light: whether to check light
trunk: tree trunk node name (optional)
leaves: leaves node name (optional)
replacement: {
	name = --node name of node to replace leaves,
	chance = -- 1 divided by this is the chance to replace leaves,
}
]]
function hades_trees.generate_tree(pos, check_light, trunk, leaves, replacement)
	if not trunk then
		trunk = "hades_trees:tree"
	end
	if not leaves then
		leaves = "hades_trees:leaves"
	end
	local orig_pos = table.copy(pos)
	local underground = table.copy(hades_trees.DEFAULT_UNDERGROUND)
	pos.y = pos.y-1
	local nodename = minetest.get_node(pos).name
	local ret = false
	for _,name in ipairs(underground) do
		if nodename == name then
			ret = true
			break
		end
	end
	if not ret then
		return
	end
	pos.y = pos.y+1
	if not check_node_light(pos, 8, check_light) then
		return
	end

	local node = {name = ""}
	for dy=1,3 do
		pos.y = pos.y+dy
		if minetest.get_node(pos).name ~= "air" then
			return
		end
		pos.y = pos.y-dy
	end
	node.name = trunk
	for dy=0,3 do
		pos.y = pos.y+dy
		minetest.set_node(pos, node)
		pos.y = pos.y-dy
	end


	local ndef = minetest.registered_nodes[node.name]

	node.name = leaves
	if ndef and ndef.paramtype2 == "color" then
		node.param2 = hades_seasons.get_seasonal_palette_color_param2()
	end
	pos.y = pos.y+4
	for dx=-2,2 do
		for dz=-2,2 do
			for dy=-1,2 do
				pos.x = pos.x+dx
				pos.y = pos.y+dy
				pos.z = pos.z+dz


				if dx == 0 and dz == 0 and dy==3 then
					if minetest.get_node(pos).name == "air" and math.random(1, 6) <= 4 then
						minetest.set_node(pos, node)
						if replacement then
							if math.random(1, replacement.chance) == 1 then
								minetest.set_node(pos, {name=replacement.name, param2=0})
							end
						end
					end
				elseif dx == 0 and dz == 0 and dy==4 then
					if minetest.get_node(pos).name == "air" and math.random(1, 6) <= 4 then
						minetest.set_node(pos, node)
						if replacement then
							if math.random(1, replacement.chance) == 1 then
								minetest.set_node(pos, {name=replacement.name, param2=0})
							end
						end
					end
				elseif math.abs(dx) ~= 2 and math.abs(dz) ~= 2 then
					if minetest.get_node(pos).name == "air" then
						minetest.set_node(pos, node)
						if replacement then
							if math.random(1, replacement.chance) == 1 then
								minetest.set_node(pos, {name=replacement.name, param2=0})
							end
						end
					end
				else
					if math.abs(dx) ~= 2 or math.abs(dz) ~= 2 then
						if minetest.get_node(pos).name == "air" and math.random(1, 6) <= 4 then
							minetest.set_node(pos, node)
							if replacement then
								if math.random(1, replacement.chance) == 1 then
									minetest.set_node(pos, {name=replacement.name, param2=0})
								end
							end
						end
					end
				end


				pos.x = pos.x-dx
				pos.y = pos.y-dy
				pos.z = pos.z-dz
			end
		end
	end
	minetest.log("action", "[hades_trees] A sapling grows into a tree at "..minetest.pos_to_string(orig_pos))
end

--[[
Generates a tree that is shaped like an apple tree.

pos: Position of tree base
check_light: whether to check light
trunk: tree trunk node name (optional)
leaves: leaves node name (optional)
replacement: {
	name = --node name of node to replace leaves,
	chance = -- 1 divided by this is the chance to replace leaves,
}
]]
function hades_trees.generate_applelike_tree(pos, check_light, trunk, leaves, replacement)
	if not trunk then
		trunk = "hades_trees:tree"
	end
	if not leaves then
		leaves = "hades_trees:leaves"
	end

	local nu = minetest.get_node({x=pos.x, y=pos.y-1, z=pos.z}).name

	local ret = false
	for _,name in ipairs(hades_trees.DEFAULT_UNDERGROUND) do
		if nu == name then
			ret = true
			break
		end
	end
	if not ret then
		return
	end

	local lpos = {x=pos.x, y=pos.y+1, z=pos.z}
	if not check_node_light(lpos, 8, check_light) then
		return
	end

	local underground = hades_trees.DEFAULT_UNDERGROUND
	local c_air = minetest.CONTENT_AIR
	local c_ignore = minetest.CONTENT_IGNORE
	local c_tree = minetest.get_content_id(trunk)
	local c_leaves = minetest.get_content_id(leaves)
	local c_replacement

	local param2
	local ndef = minetest.registered_nodes[leaves]
	if ndef and ndef.paramtype2 == "color" then
		param2 = hades_seasons.get_seasonal_palette_color_param2()
	else
		param2 = 0
	end

	if replacement.name then
		c_replacement = minetest.get_content_id(replacement.name)
	end

	local vm = minetest.get_voxel_manip()
	local minp, maxp = vm:read_from_map({x=pos.x-16, y=pos.y, z=pos.z-16}, {x=pos.x+16, y=pos.y+16, z=pos.z+16})
	local a = VoxelArea:new{MinEdge=minp, MaxEdge=maxp}
	local data = vm:get_data()
	local data_p2 = vm:get_param2_data()

	if not pr_a then
		local seed = math.random(1,100000)
		pr_a = PseudoRandom(seed)
	end
        local th = pr_a:next(4, 6)
        local x, y, z = pos.x, pos.y, pos.z
        for yy = y, y+th-1 do
                local vi = a:index(x, yy, z)
                if a:contains(x, yy, z) and (data[vi] == c_air or yy == y) then
                        data[vi] = c_tree
                end
        end
        y = y+th-1 -- (x, y, z) is now last piece of trunk
        local leaves_a = VoxelArea:new{MinEdge={x=-2, y=-2, z=-2}, MaxEdge={x=2, y=2, z=2}}
        local leaves_buffer = {}

        -- Force leaves near the trunk
        local d = 1
        for xi = -d, d do
        for yi = -d, d do
        for zi = -d, d do
                leaves_buffer[leaves_a:index(xi, yi, zi)] = true
        end
        end
        end

        -- Add leaves randomly
        for iii = 1, 8 do
                local d = 1
                local xx = pr_a:next(leaves_a.MinEdge.x, leaves_a.MaxEdge.x - d)
                local yy = pr_a:next(leaves_a.MinEdge.y, leaves_a.MaxEdge.y - d)
                local zz = pr_a:next(leaves_a.MinEdge.z, leaves_a.MaxEdge.z - d)

                for xi = 0, d do
                for yi = 0, d do
                for zi = 0, d do
                        leaves_buffer[leaves_a:index(xx+xi, yy+yi, zz+zi)] = true
                end
                end
                end
	end

	-- Add the leaves
	for xi = leaves_a.MinEdge.x, leaves_a.MaxEdge.x do
	for yi = leaves_a.MinEdge.y, leaves_a.MaxEdge.y do
	for zi = leaves_a.MinEdge.z, leaves_a.MaxEdge.z do
		if a:contains(x+xi, y+yi, z+zi) then
			local vi = a:index(x+xi, y+yi, z+zi)
			if data[vi] == c_air or data[vi] == c_ignore then
				if leaves_buffer[leaves_a:index(xi, yi, zi)] then
					if c_replacement and pr_a:next(1, replacement.chance) == 1 then
						data[vi] = c_replacement
						data_p2[vi] = 0
					else
						data[vi] = c_leaves
						data_p2[vi] = param2
					end
				end
			end
		end
	end
	end
	end

	vm:set_data(data)
	vm:set_param2_data(data_p2)
	vm:write_to_map()
	vm:update_map()
	minetest.log("action", "[hades_trees] A sapling grows into a tree at "..minetest.pos_to_string(pos))
end

--[[
Generate a tree with a cuboid shape.

pos: Position of tree base
check_light: whether to check light
trunk: tree trunk node name (optional)
leaves: leaves node name (optional)
replacement: {
	name = --node name of node to replace leaves,
	chance = -- 1 divided by this is the chance to replace leaves,
}
underground: optional list of ground nodes on which to grow

config:
* min_light: min light level to grow
* trunk_height: height of trunk nodes
* leaves_start_height: height above base at which leaves appear
* leaves_height: total height of leaves
* leaves_outwards: how much leaves spread on the X/Z plane
* leaves_chance_denominator: chance of a leaves node to generate is this devided by the number below
* leaves_chance_numerator: chance of a leaves node to generate is the number above divided by this
]]

function hades_trees.generate_cuboid_tree(pos, check_light, trunk, leaves, replacement, underground, config)
	if not trunk then
		trunk = "hades_trees:tree"
	end
	if not leaves then
		leaves = "hades_trees:leaves"
	end
	underground = underground or hades_trees.DEFAULT_UNDERGROUND
	if not config then
		config = {}
	end
	if not config.min_light then
		config.min_light = 8
	end

	pos.y = pos.y-1
	-- Check underground
	local nodename = minetest.get_node(pos).name
	local ret = false
	for _,name in ipairs(underground) do
		if nodename == name then
			ret = true
			break
		end
	end
	if not ret then
		return
	end

	-- Check light
	pos.y = pos.y+1
	if not check_node_light(pos, config.min_light, check_light) then
		return
	end

	-- Check if enough space to grow
	local node = {name = ""}
	for dy=1,config.trunk_height  do
		pos.y = pos.y+dy
		if minetest.get_node(pos).name ~= "air" then
			return
		end
		pos.y = pos.y-dy
	end
	local trunknodes = {}
	for dy=0,config.trunk_height-1 do
		pos.y = pos.y+dy
		local tnode = minetest.get_node(pos)
		table.insert(trunknodes, table.copy(pos))
		pos.y = pos.y-dy
	end

	local leafnodes = {}
	local replacementnodes = {}
	for dx=-config.leaves_outwards, config.leaves_outwards do
		for dz=-config.leaves_outwards, config.leaves_outwards do
			for dy=config.leaves_start_height, config.leaves_start_height + config.leaves_height - 1 do
				pos.x = pos.x+dx
				pos.y = pos.y+dy
				pos.z = pos.z+dz
				if dx ~= 0 or dz ~= 0 or dy > config.trunk_height then
					local tnode = minetest.get_node(pos)
					if tnode.name == "air" and math.random(1, config.leaves_chance_denominator) <= config.leaves_chance_numerator then
						local replaced = false
						if replacement and replacement.name then
							if math.random(1, replacement.chance) == 1 then
								table.insert(replacementnodes, table.copy(pos))
								replaced = true
							end
						end
						if not replaced then
							table.insert(leafnodes, table.copy(pos))
						end
					end
				end
				pos.x = pos.x-dx
				pos.y = pos.y-dy
				pos.z = pos.z-dz
			end
		end
	end

	node.name = trunk
	minetest.bulk_set_node(trunknodes, node)
	node.name = leaves
	local ndef = minetest.registered_nodes[node.name]
	if ndef and ndef.paramtype2 == "color" then
		node.param2 = hades_seasons.get_seasonal_palette_color_param2()
	end
	minetest.bulk_set_node(leafnodes, node)
	if #replacementnodes > 0 then
		node.name = replacement.name
		node.param2 = 0
		minetest.bulk_set_node(replacementnodes, node)
	end

end

