local S = minetest.get_translator("hades_trees")

local generate_cjtree = function(pos, check_light, trunk, leaves)
	trunk = trunk or "hades_trees:jungle_tree"
	leaves = leaves or "hades_trees:cultivated_jungle_leaves"
	local config = {
		trunk_height = 13,
		leaves_start_height = 10,
		leaves_height = 5,
		leaves_outwards = 3,
		leaves_chance_numerator = 4,
		leaves_chance_denominator = 5,
	}
	hades_trees.generate_cuboid_tree(pos, check_light, trunk, leaves, nil, nil, config)
end

hades_trees.register_leaves("cultivated_jungle_leaves", {
	description = S("Cultivated Tropical Leaves"),
	image = "hades_trees_cultivated_jungle_leaves_colorable.png",
	colorable = true,
	palette = "hades_trees_cultivated_jungle_leaves_palette.png",
	color_stereotype = "#608000",
	ash_fertilizer = 3,
	drop_item = "hades_trees:cultivated_jungle_seed",
	drop_rarity = 25,
	trunk = "hades_trees:jungle_tree",
})
hades_trees.register_sapling("cultivated_jungle_sapling", {
	description = S("Cultivated Tropical Tree Sapling"),
	image = "hades_trees_cultivated_jungle_sapling.png",
	selbox = {-0.3, -0.5, -0.3, 0.3, 0.35, 0.3},
	grow = generate_cjtree,
})
hades_trees.register_seed("cultivated_jungle_seed", {
	description = S("Cultivated Tropical Tree Seed"),
	image = "hades_trees_cultivated_jungle_seed.png",
	_hades_grows_to = "hades_trees:cultivated_jungle_sapling",
})

hades_trees.register_grow_abms({
	label = "Grow cultivated tropical tree sapling and seed",
	sapling = "hades_trees:cultivated_jungle_sapling",
	seed = "hades_trees:cultivated_jungle_seed",
	interval = 30,
	chance = 20,
})
