List of groups used in Hades Revisited (info for developers)
------------------------------------------------------------

Note: If no group rating is specified, use 1.

Node identities:
* `tree`: Tree Trunk
* `sapling`: Sapling
* `leaves`: Leaves
* `bark`: Bark
* `seaweed`: Seaweed
* `waterlily`: Waterlily
* `plant`: Generic plant
* `farming_plant`: A plant for farming (wheat, etc.)
* `grass`: Grass
* `grass_clump=s`: Grass clump (s = growth stage)
* `dead_grass_clump=s`: Dead grass clump (s = growth stage)
* `junglegrass=s`: Tropical grass (s = growth stage)
* `flower`: Flower
* `vines=1`: Vines (sideways)
    * `vines=2` Vines (centered)
* `vines_rotten=1`: Rotten vines
* `vines_flowering=1`: Flowering vines
* `papyrus`: Papyrus
* `sugarcane`: Sugarcane
* `simple_bush`: Garden bush
* `dirt`: Dirt
* `clay`: Clay

* `seed`: Seed
* `seed_farming`: Seed from the `hades_farming` mod
* `seed_simple_bush`: Seed for a garden bush
* `wheat`: Wheat plant
* `strawberry` Strawberry plant
* `tomato` Tomato plant
* `cotton`: Cotton plant

* `colwood`: Colored wooden planks
* `claybricks`: Clay bricks
* `cloth`: Cloth

* `carpet`: Carpet
* `table`: Table
* `chair`: Chair
* `armchair`: Armchair
* `window_wood`: Wooden window

* `chest`: Chest
* `unlocked_chest`: Unlocked chest
* `locked_chest`: Locked chest
* `furnace`: Furnace
    * `furnace=1`: Inactive furnace
    * `furnace=2`: Active furnace
* `torch`: Torch
* `door`: Door
* `steel_door`: Steel Door
* `bed`: Bed
* `fence`: Fence
* `fence_gate`: Fence gate
* `fence_metal`: Metal fence
* `fence_wood`: Wooden fence
* `wall`: Wall
* `ladder`: Ladder
* `ladder_wood`: Wooden ladder
* `vessel`: Vessel, like glass bottle
* `mob_spawner`: Mob spawner
* `trash_can`: Trash can

* `mossy`: Block has moss on it
* `burned_node`: Node that was "burned" by lava like Burned Stone
* `ore`: Ore
* `sandstone`: Sandstone
* `ash`: Ash

* `liquid`: Liquid
* `water`: Water
* `lava`: Lava

Digging groups:
* `choppy`: Wood, etc.
* `cracky`: Stone, etc.
* `oddly_breakable_by_hand`: Breakable by hand for ... reasons
* `snappy`: Leaves, plants, etc.

Crafting groups:
* `wood`: Wooden planks
* `sand`: Sand
* `stone`: Stone or stone-like

Items:
* `shears`: Shears
* `shovel`: Shovel
* `axe`: Axe
* `pickaxe`: Pickaxe
* `sword`: Sword
* `tool`: Tool
* `dye`: Dye
* `spawn_egg`: Spawn egg (spawns mobs)
* `virtual`: For any items and nodes that should normally only exist or work in the simulation
* `simulation_grid`: Simulation grid node (the inner boundary of a simulation room)
* `simulation_hull`: Simulation hull node (the outer boundary of a simluation room)

Action groups:
* `bag=1`: Bag
* `bagslots=X`: Bag with X slots
* `equipment=1`: Item for the Equipment slots in player inventory
* `food=1`: Food (unspecified type)
*   `food=2`: Food (eating)
*   `food=3`: Food (drinking)
* `eatable=X`: Item can be eaten or consumed (restoring X food points)
* `leafdecay=X`: Leaves that decay when not near a node specified in `_hades_trees_trunk` field (X=distance from node)
* `leafdecay_any`: In combination with `leafdecay`, will expect a `group:tree` node instead to prevent decay
* `leafdecay_drop`: Node will drop itself when leaf-decaying
* `leafseasonal=1`: For leaves nodes that will change color with the seasons
* `wet` Considered wet for farming purposes
* `fruit_regrow=3`: Regrowing fruit
*   `fruit_regrow=2`: Regrowing fruit (flower stage)
*   `fruit_regrow=1`: Regrowing fruit (bud stage)
* `ash_fertilizer=X`: Node slowly turns nearby Volcanic Ash to Fertile Sand (distance X, usually 3)
* `porous`: If water is above this node, water droplets might appear below it
* `fake_liquid`: Node is registerd as liquid but it's not actually a liquid
* `flower_spread`: This is a flower that spreads on Dirt with Grass in the correct season
* `grass_spread`: This is a grass plant that spreads on Dirt with Grass in the correct season
* `soil`: Soil, or can be turned into soil by hoe
    * `soil=1`: Not soil yet, but can be turned into soil by hoe
    * `soil=2`: (Dry) soil
    * `soil=3`: Wet soil
* `not_in_craft_guide`: Item won't appear in craft guide
* `rotation_takes_precedence=1`: Group for nodes. Normally, if rotation tool (e.g. screwdriver) is "placed"
   on this node, the `on_rightclick` action takes precedence, and the rotation action is used when Sneak
   key is held. But if this group is set, it's the other way around: The rotation action is executed
   by default and if Sneak is pressed, `on_rightclick` is executed instead

Other groups
* `flammable`: Item would burn if ignited (note: this game doesn't have fire, so this group is rather esoteric
               and currently only used for special stuff like fuel recipes)

Legacy groups:
* `puts_out_fire`: Node is supposed to put out neighboring fire (Note: This game has no fire)
