local S = minetest.get_translator("hades_core")


minetest.register_node("hades_core:cactus", {
	description = S("Cactus"),
	_tt_help = S("Grows on sand and ash"),
	tiles = {"default_cactus_top.png", "hades_core_cactus_bottom.png", "default_cactus_side.png"},
	paramtype = "light",
	is_ground_content = true,
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = {
			{-0.5,-0.5,-3/16, 0.5,0.5,3/16},
			{-7/16,-0.5,-5/16, 7/16,0.5,5/16},
			{-6/16,-0.5,-6/16, 6/16,0.5,6/16},
			{-5/16,-0.5,-7/16, 5/16,0.5,7/16},
			{-3/16,-0.5,-0.5, 3/16,0.5,0.5},
		},
	},
	collision_box = {
		type = "fixed",
		fixed = {{ -0.5, -0.5, -0.5, 0.5, 0.5, 0.5 }},
	},
	groups = {snappy=1,choppy=3,flammable=2,cactus=1},
	sounds = hades_sounds.node_sound_wood_defaults(),
})

minetest.register_node("hades_core:cactus_rotten", {
	description = S("Rotten Cactus"),
	tiles = {"hades_core_cactus_rotten_top.png", "hades_core_cactus_rotten_bottom.png", "hades_core_cactus_rotten_side.png"},
	paramtype = "light",
	is_ground_content = true,
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = {
			{-0.5,-0.5,-3/16, 0.5,0.5,3/16},
			{-7/16,-0.5,-5/16, 7/16,0.5,5/16},
			{-6/16,-0.5,-6/16, 6/16,0.5,6/16},
			{-5/16,-0.5,-7/16, 5/16,0.5,7/16},
			{-3/16,-0.5,-0.5, 3/16,0.5,0.5},
		},
	},
	collision_box = {
		type = "fixed",
		fixed = {{ -0.5, -0.5, -0.5, 0.5, 0.5, 0.5 }},
	},
	groups = {snappy=1,choppy=3,flammable=2,cactus=1},
	sounds = hades_sounds.node_sound_wood_defaults(),
})



minetest.register_node("hades_core:cactus_fig", {
	description = S("Cactus Fig"),
	_tt_help = S("Grows on a cactus on fertile sand").."\n"..S("Season: Summer"),
	tiles = {"hades_core_cactus_fig.png"},
	inventory_image = "hades_core_cactus_fig_item.png",
	wield_image = "hades_core_cactus_fig_item.png",
	paramtype = "light",
	paramtype2 = "meshoptions",
	place_param2 = 1,
	sunlight_propagates = true,
	is_ground_content = false,
	drawtype = "plantlike",
	walkable = false,
	selection_box = {
		type = "fixed",
		fixed = { -5/16, -0.5, -5/16, 5/16, 2/16, 5/16 },
	},
	sounds = hades_sounds.node_sound_bush_defaults(),
	on_use = minetest.item_eat(2),
	groups = { food = 2, eatable = 2, choppy =3, flammable = 2, attached_node = 1 },
})

hades_seeds.register_seed("hades_core:seed_cactus", {
	description = S("Cactus Seed"),
	_tt_help = S("Grows on sand and ash"),
	image = "hades_core_cactus_seed.png",
	surface_check = function(node)
		return minetest.get_item_group(node.name, "ash") ~= 0 or minetest.get_item_group(node.name, "sand") ~= 0
	end,
	_hades_grows_to = "hades_core:cactus",
})

minetest.register_node("hades_core:cactus_block", {
	description = S("Cactus Block"),
	tiles = {"hades_core_cactus_block.png"},
	is_ground_content = false,
	groups = {choppy=3,flammable=2},
	sounds = hades_sounds.node_sound_wood_defaults(),
})

minetest.register_node("hades_core:cactus_brick", {
	description = S("Cactus Brick"),
	tiles = {"hades_core_cactus_brick.png"},
	is_ground_content = false,
	groups = {choppy=3,flammable=2},
	sounds = hades_sounds.node_sound_wood_defaults(),
})

minetest.register_node("hades_core:glowing_cactus_block", {
	description = S("Glowing Cactus Block"),
	tiles = {"hades_core_glowing_cactus_block.png"},
	is_ground_content = false,
	light_source = 5,
	groups = {choppy=3,flammable=2},
	sounds = hades_sounds.node_sound_wood_defaults(),
})

-- Dig all nodes upwards from pos.
-- It iterates through all nodes from pos upwards as long they're
-- member of the given group.
-- * pos: Starting position
-- * group: Name of group of the nodes to dig
-- * digger: An object that should be reported as the digger
local function dig_up(pos, group, digger)
	if digger == nil then
		return
	end
	local np = {x = pos.x, y = pos.y + 1, z = pos.z}
	local nn = minetest.get_node(np)
	if minetest.get_item_group(nn.name, group) ~= 0 then
		minetest.node_dig(np, nn, digger)
	end
end

do
-- Papyrus

-- helper variables for nodebox
-- Papyrus stem, thickness
local a = 0
local b = 1/16

-- Papyrus bump, height
local d = 0
local f = 1/16

-- Papyrus bump, width
local c = -1/16
local e = 2/16

minetest.register_node("hades_core:papyrus", {
	description = S("Papyrus"),
	_tt_help = S("Grows on dirt near water"),
	drawtype = "nodebox",
	tiles = {
		"hades_core_papyrus_3d.png",
		"hades_core_papyrus_3d.png",
		"hades_core_papyrus_3d_s1.png",
		"hades_core_papyrus_3d_s1.png",
		"hades_core_papyrus_3d_s2.png",
		"hades_core_papyrus_3d_s2.png",
	},
	inventory_image = "default_papyrus.png",
	wield_image = "default_papyrus.png",
	paramtype = "light",
	is_ground_content = true,
	floodable = true,
	walkable = false,
	selection_box = {
		 type = "fixed",
		 fixed = {-0.4375, -0.5, -0.4375, 0.4375, 0.5, 0.4375}
	},
	node_box = {
		type = "fixed",
                 fixed = {
                         --papyrus 1
                         {a-2/16,-0.5,a-2/16, b-2/16,0.5,b-2/16},
                         {c-2/16,d-2/16,c-2/16, e-2/16,f-2/16,e-2/16},
                         --papyrus 2
                         {a-6/16,-0.5,a-5/16, b-6/16,0.5,b-5/16},
                         {c-6/16,d-3/16,c-5/16, e-6/16,f-3/16,e-5/16},
                         --papyrus 3
                         {a+6/16,-0.5,a-5/16,b+6/16,0.5,b-5/16},
                         {c+6/16,d+3/16,c-5/16, e+6/16,f+3/16,e-5/16},
                         --papyrus 4
                         {a-6/16,-0.5,a+6/16, b-6/16,0.5,b+6/16},
                         {c-6/16,d+6/16,c+6/16, e-6/16,f+6/16,e+6/16},
                         --papyrus 5
                         {a-3/16,-0.5,a+3/16, b-3/16,0.5,b+3/16},
                         {c-3/16,d-6/16,c+3/16, e-3/16,f-6/16,e+3/16},
                         --papyrus 6
                         {a+2/16,-0.5,a+3/16, b+2/16,0.5,b+3/16},
                         {c+2/16,d+5/16,c+3/16, e+2/16,f+5/16,e+3/16},
                 },
	},
	groups = {snappy = 3,flammable = 2,papyrus = 1},
	sounds = hades_sounds.node_sound_grass_defaults(),
	
	after_dig_node = function(pos, node, metadata, digger)
		dig_up(pos, "papyrus", digger)
	end,
})
end

local papyrus_def = table.copy(minetest.registered_nodes["hades_core:papyrus"])
papyrus_def.description = S("Rotten Papyrus")
papyrus_def._tt_help = nil
papyrus_def.tiles = {
	"hades_core_papyrus_rotten_3d.png",
	"hades_core_papyrus_rotten_3d.png",
	"hades_core_papyrus_rotten_3d_s1.png",
	"hades_core_papyrus_rotten_3d_s1.png",
	"hades_core_papyrus_rotten_3d_s2.png",
	"hades_core_papyrus_rotten_3d_s2.png",
}
papyrus_def.inventory_image = "hades_core_papyrus_rotten.png"
papyrus_def.wield_image = "hades_core_papyrus_rotten.png"
minetest.register_node("hades_core:papyrus_rotten", papyrus_def)

hades_seeds.register_seed("hades_core:seed_papyrus", {
	description = S("Papyrus Seed"),
	_tt_help = S("Grows on dirt near water"),
	image = "hades_core_papyrus_seed.png",
	surface_check = function(node)
		return minetest.get_item_group(node.name, "dirt") ~= 0
	end,
	_hades_grows_to = "hades_core:papyrus",
})

minetest.register_node("hades_core:sugarcane", {
	description = S("Sugarcane"),
	_tt_help = S("Grows on dirt").."\n"..S("Seasons: Summer, Fall"),
	drawtype = "plantlike",
	tiles = {"hades_core_sugarcane.png"},
	inventory_image = "hades_core_sugarcane.png",
	wield_image = "hades_core_sugarcane.png",
	paramtype = "light",
	walkable = false,
	is_ground_content = true,
	floodable = true,
	selection_box = {
		type = "fixed",
		fixed = {-0.3, -0.5, -0.3, 0.3, 0.5, 0.3}
	},
	groups = {snappy=3,flammable=2,sugarcane=1},
	sounds = hades_sounds.node_sound_bush_defaults(),
	
	after_dig_node = function(pos, node, metadata, digger)
		dig_up(pos, "sugarcane", digger)
	end,
})
local sugarcane_def = table.copy(minetest.registered_nodes["hades_core:sugarcane"])
sugarcane_def.description = S("Rotten Sugarcane")
sugarcane_def._tt_help = nil
sugarcane_def.tiles = {"hades_core_sugarcane_rotten.png"}
sugarcane_def.inventory_image = "hades_core_sugarcane_rotten.png"
sugarcane_def.wield_image = "hades_core_sugarcane_rotten.png"
minetest.register_node("hades_core:sugarcane_rotten", sugarcane_def)

hades_seeds.register_seed("hades_core:seed_sugarcane", {
	description = S("Sugarcane Seed"),
	_tt_help = S("Grows on dirt near water"),
	image = "hades_core_sugarcane_seed.png",
	surface_check = function(node)
		return minetest.get_item_group(node.name, "dirt") ~= 0
	end,
	_hades_grows_to = "hades_core:sugarcane",
})
