local S = minetest.get_translator("hades_trees")

local function generate_coconutpalm(pos, check_light, trunk, leaves, replacement)
	if not trunk then
		trunk = "hades_trees:jungle_tree"
	end
	if not leaves then
		leaves = "hades_trees:jungle_leaves"
	end
	hades_trees.generate_tree(pos, check_light, trunk, leaves, replacement)
end

hades_trees.register_sapling("coconut_sapling", {
	description = S("Coconut Palm Sapling"),
	image = "hades_trees_coconut_sapling.png",
	selbox = {-0.25, -0.5, -0.25, 0.25, 0.35, 0.25},
	grow = generate_coconutpalm,
	fruit = "hades_trees:coconut",
	fruit_chance = 20,
})
hades_trees.register_seed("coconut_seed", {
	description = S("Coconut Seed"),
	image = "hades_trees_coconut_seed.png",
	_hades_grows_to = "hades_trees:coconut_sapling",
})

hades_trees.register_fruit("coconut", {
	description = S("Coconut"),
	drawtype = "plantlike",
	image = "hades_trees_coconut.png",
	selbox = {-5/16, -7/16, -5/16, 5/16, 7/16, 5/16},
	sounds = hades_sounds.node_sound_wood_defaults(),
})

hades_trees.register_grow_abms({
	label = "Grow coconut sapling and seed",
	sapling = "hades_trees:coconut_sapling",
	seed = "hades_trees:coconut_seed",
	interval = 30,
	chance = 20,
})
