local S = minetest.get_translator("hades_trees")

local generate_orangetree = function(pos, check_light, trunk, leaves, replacement)
	if not trunk then
		trunk = "hades_trees:orange_tree"
	end
	if not leaves then
		leaves = "hades_trees:orange_leaves"
	end
	hades_trees.generate_tree(pos, check_light, trunk, leaves, replacement)
end

hades_trees.register_trunk("orange_tree", {
	description = S("Orange Tree Trunk"),
	tiles = {"hades_trees_orange_tree_top.png", "hades_trees_orange_tree_top.png", "hades_trees_orange_tree.png"},
})
hades_trees.register_bark("orange_bark", {
	description = S("Orange Bark"),
	image = "hades_trees_orange_tree.png",
})

hades_trees.register_leaves("orange_leaves", {
	description = S("Orange Leaves"),
	image = "hades_trees_orange_leaves_colorable.png",
	colorable = true,
	palette = "hades_trees_orange_leaves_palette.png",
	color_stereotype = "#28931b",
	ash_fertilizer = 3,
	trunk = "hades_trees:orange_tree",
})
hades_trees.register_sapling("orange_sapling", {
	description = S("Orange Tree Sapling"),
	image = "hades_trees_orange_sapling.png",
	selbox = {-0.3, -0.5, -0.3, 0.3, 0.35, 0.3},
	grow = generate_orangetree,
	fruit = "hades_trees:orange",
	fruit_chance = 20,
})
hades_trees.register_seed("orange_seed", {
	description = S("Orange Seed"),
	image = "hades_trees_orange_seed.png",
	_hades_grows_to = "hades_trees:orange_sapling",
})


hades_trees.register_fruit("orange", {
	description = S("Orange"),
	drawtype = "plantlike",
	image = "hades_trees_orange.png",
	selbox = {-3/16, -4/16, -3/16, 3/16, 5/16, 3/16},
	satiation = 1,
})

hades_trees.register_grow_abms({
	label = "Grow orange sapling and seed",
	sapling = "hades_trees:orange_sapling",
	seed = "hades_trees:orange_seed",
	interval = 30,
	chance = 10,
})
