local S = minetest.get_translator("hades_trees")

-- TODO: Customize cocoa tree
local function generate_cocoatree(pos, check_light, trunk, leaves, replacement)
	if not trunk then
		trunk = "hades_trees:jungle_tree"
	end
	if not leaves then
		leaves = "hades_trees:jungle_leaves"
	end
	hades_trees.generate_tree(pos, check_light, trunk, leaves, replacement)
end

hades_trees.register_sapling("cocoa_sapling", {
	description = S("Cocoa Tree Sapling"),
	image = "hades_trees_cocoa_sapling.png",
	selbox = {-0.3, -0.5, -0.3, 0.3, 0.35, 0.3},
	grow = generate_cocoatree,
	fruit = "hades_trees:cocoa_pod",
	fruit_chance = 12,
})
hades_trees.register_fruit("cocoa_pod", {
	description = S("Cocoa Pod"),
	drawtype = "plantlike",
	image = "hades_trees_cocoa_pod.png",
	selbox = {-5/16, -7/16, -5/16, 5/16, 0.5, 5/16},
	sounds = hades_sounds.node_sound_wood_defaults(),
	-- TODO: Remove when cocoa is ready
	groups = {not_in_craft_guide = 1},
})

hades_trees.register_seed("cocoa_beans", {
	description = S("Cocoa Beans"),
	image = "hades_trees_cocoa_beans.png",
	_hades_grows_to = "hades_trees:cocoa_sapling",
})

hades_trees.register_grow_abms({
	label = "Grow cocoa sapling and seed",
	sapling = "hades_trees:cocoa_sapling",
	seed = "hades_trees:cocoa_beans",
	interval = 30,
	chance = 20,
})

minetest.register_alias("hades_trees:cocoa_bean", "hades_trees:cocoa_beans")
