local S = minetest.get_translator("hades_refruit")

local stick_drop = function(rarity)
	return {
		max_items = 1,
		items = {
			{
				items = {'hades_core:stick'},
				rarity = rarity
			}
		}
	}
end

-- TODO: Balance out the season availability of fruit
hades_refruit.add_hades_refruit("apple", {
	-- available in all seasons because this is the starter fruit
	-- TODO: Restrict to fall later
	fruit_itemstring = "hades_trees:apple",
	sapling_itemstring = "hades_trees:sapling",
	bud_description = S("Apple Bud"),
	flower_description = S("Apple Flower"),
	bud_interval = 34,
	bud_chance = 10,
	flower_interval = 33,
	flower_chance = 60,
	fruit_interval = 33,
	fruit_chance = 20,
	neighbors = {"hades_trees:leaves"},
	trunk = "hades_trees:tree",
	bud_selbox = {-0.1875, -0.3125, -0.1875, 0.1875, 0.3125, 0.1875},
	flower_selbox = {-0.1875, -0.3125, -0.1875, 0.1875, 0.3125, 0.1875},
})

hades_refruit.add_hades_refruit("pear", {
	fruit_itemstring = "hades_trees:pear",
	sapling_itemstring = "hades_trees:pear_sapling",
	bud_description = S("Pear Bud"),
	flower_description = S("Pear Flower"),
	bud_interval = 34,
	bud_chance = 10,
	flower_interval = 33,
	flower_chance = 60,
	fruit_interval = 33,
	fruit_chance = 20,
	neighbors = {"hades_trees:pear_leaves"},
	trunk = "hades_trees:pear_tree",
	bud_selbox = {-0.125, -0.125, -0.125, 0.1875, 0.375, 0.125},
	flower_selbox = {-0.1875, -0.25, -0.1875, 0.1875, 0.3125, 0.1875},
	seasons = { hades_seasons.SEASON_FALL },
})

hades_refruit.add_hades_refruit("olive", {
	fruit_itemstring = "hades_trees:olive",
	sapling_itemstring = "hades_trees:olive_sapling",
	bud_description = S("Olive Bud"),
	flower_description = S("Olive Flower"),
	flower_drop = stick_drop(76),
	bud_interval = 35,
	bud_chance = 10,
	flower_interval = 34,
	flower_chance = 60,
	fruit_interval = 34,
	fruit_chance = 20,
	neighbors = {"hades_trees:olive_leaves"},
	trunk = "hades_trees:olive_tree",
	bud_selbox = {-2/16, 1/16, -2/16, 2/16, 0.5, 2/16},
	flower_selbox = {-4/16, -1/16, -4/16, 4/16, 0.5, 4/16},
	seasons = { hades_seasons.SEASON_SUMMER },
})

hades_refruit.add_hades_refruit("orange", {
	fruit_itemstring = "hades_trees:orange",
	sapling_itemstring = "hades_trees:orange_sapling",
	--~ Bud for the orange fruit of an orange tree
	bud_description = S("Orange Bud"),
	--~ Flower for the orange fruit of an orange tree
	flower_description = S("Orange Flower"),
	bud_interval = 34,
	bud_chance = 10,
	flower_interval = 33,
	flower_chance = 60,
	fruit_interval = 33,
	fruit_chance = 20,
	neighbors = {"hades_trees:orange_leaves"},
	trunk = "hades_trees:orange_tree",
	bud_selbox = {-0.1875, -0.4375, -0.1875, 0.1875, 0.25, 0.1875},
	flower_selbox = {-0.1875, -0.4375, -0.1875, 0.1875, 0.25, 0.1875},
	seasons = { hades_seasons.SEASON_SPRING },
})

hades_refruit.add_hades_refruit("banana", {
	fruit_itemstring = "hades_trees:banana",
	sapling_itemstring = "hades_trees:banana_sapling",
	bud_description = S("Banana Bud"),
	flower_description = S("Banana Flower"),
	bud_interval = 35,
	bud_chance = 10,
	flower_interval = 34,
	flower_chance = 60,
	fruit_interval = 34,
	fruit_chance = 20,
	neighbors = {"hades_trees:banana_leaves"},
	trunk = "hades_trees:banana_tree",
	bud_selbox = {-0.1875, -0.4375, -0.1875, 0.1875, 0.25, 0.1875},
	flower_selbox = {-0.1875, -0.4375, -0.1875, 0.1875, 0.25, 0.1875},
	seasons = { hades_seasons.SEASON_SUMMER },
})

hades_refruit.add_hades_refruit("cocoa", {
	fruit_itemstring = "hades_trees:cocoa_pod",
	sapling_itemstring = "hades_trees:cocoa_sapling",
	bud_description = S("Cocoa Bud"),
	flower_description = S("Cocoa Flower"),
	bud_interval = 35,
	bud_chance = 10,
	flower_interval = 34,
	flower_chance = 60,
	fruit_interval = 34,
	fruit_chance = 20,
	neighbors = {"hades_trees:cocoa_leaves"},
	trunk = "hades_trees:cocoa_tree",
	bud_selbox = {-0.1875, -0.25, -0.1875, 0.1875, 0.375, 0.1875},
	flower_selbox = {-0.1875, -0.1875, -0.1875, 0.1875, 0.5, 0.1875},
	seasons = { hades_seasons.SEASON_FALL },
})

hades_refruit.add_hades_refruit("coconut", {
	fruit_itemstring = "hades_trees:coconut",
	sapling_itemstring = "hades_trees:coconut_sapling",
	bud_description = S("Coconut Bud"),
	flower_description = S("Coconut Flower"),
	bud_drop = stick_drop(100),
	flower_drop = stick_drop(40),
	bud_interval = 35,
	bud_chance = 10,
	flower_interval = 34,
	flower_chance = 60,
	fruit_interval = 34,
	fruit_chance = 60,
	neighbors = {"hades_trees:coconut_leaves"},
	trunk = "hades_trees:coconut_tree",
	bud_selbox = {-2/16, -6/16, -2/16, 2/16, 3/16, 2/16},
	flower_selbox = {-4/16, -7/16, -4/16, 4/16, 7/16, 4/16},
	seasons = { hades_seasons.SEASON_SPRING },
})

hades_refruit.add_hades_refruit("birch_catkin", {
	fruit_itemstring = "hades_trees:birch_catkin",
	sapling_itemstring = "hades_trees:birch_sapling",
	bud_description = S("Birch Bud"),
	flower_description = S("Young Birch Catkin"),
	bud_interval = 35,
	bud_chance = 10,
	flower_interval = 34,
	flower_chance = 60,
	fruit_interval = 34,
	fruit_chance = 20,
	neighbors = {"hades_trees:birch_leaves"},
	trunk = "hades_trees:birch_tree",
	bud_selbox = {-2/16, 3/16, -2/16, 2/16, 0.5, 2/16},
	flower_selbox = {-3/16, 1/16, -3/16, 3/16, 0.5, 3/16},
	seasons = { hades_seasons.SEASON_SPRING },
})

hades_refruit.add_hades_refruit("bland_fruit", {
	fruit_itemstring = "hades_trees:bland_fruit",
	sapling_itemstring = "hades_trees:pale_sapling",
	bud_description = S("Pale Bud"),
	flower_description = S("Pale Flower"),
	bud_interval = 35,
	bud_chance = 10,
	flower_interval = 34,
	flower_chance = 60,
	fruit_interval = 34,
	fruit_chance = 20,
	neighbors = {"hades_trees:pale_leaves"},
	trunk = "hades_trees:pale_tree",
	bud_selbox = {-2/16, -2/16, -2/16, 2/16, 5/16, 2/16},
	flower_selbox = {-3/16, -4/16, -3/16, 3/16, 5/16, 3/16},
	seasons = { hades_seasons.SEASON_SPRING },
})

hades_refruit.add_hades_refruit("canvas_fruit", {
	fruit_itemstring = "hades_trees:canvas_fruit",
	sapling_itemstring = "hades_trees:canvas_sapling",
	bud_description = S("Canvas Bud"),
	flower_description = S("Canvas Flower"),
	bud_interval = 35,
	bud_chance = 10,
	flower_interval = 34,
	flower_chance = 60,
	fruit_interval = 34,
	fruit_chance = 20,
	neighbors = {"hades_trees:canvas_leaves"},
	trunk = "hades_trees:canvas_tree",
	bud_selbox = {-3/16, -2/16, -3/16, 3/16, 0.5, 3/16},
	flower_selbox = {-3/16, -4/16, -3/16, 3/16, 4/16, 3/16},
})

hades_refruit.add_hades_refruit("kaki", {
	fruit_itemstring = "hades_trees:kaki",
	sapling_itemstring = "hades_trees:jungle_sapling",
	--~ Bud of the kaki fruit of the kaki tree (Diospyros kaki)
	bud_description = S("Kaki Bud"),
	--~ Flower the kaki tree, can turn into kaki fruit (Diospyros kaki)
	flower_description = S("Kaki Flower"),
	bud_interval = 24,
	bud_chance = 8,
	flower_interval = 25,
	flower_chance = 50,
	fruit_interval = 25,
	fruit_chance = 24,
	neighbors = {"hades_trees:jungle_leaves"},
	trunk = "hades_trees:jungle_tree",
	bud_selbox = {-0.15, -0.1875, -0.15, 0.15, 0.375, 0.15},
	flower_selbox = {-0.225, -0.25, -0.225, 0.225, 0.3125, 0.225},
	seasons = { hades_seasons.SEASON_SUMMER },
})
