local S = minetest.get_translator("hades_food")

local register_plate = function(id, def)
	local on_use, stack_max
	if def.eatable then
		on_use = minetest.item_eat(def.eatable, "hades_food:plate")
		stack_max = 2
	end
	minetest.register_node(id, {
		description = def.description,
		inventory_image = def.image,
		wield_image = def.image,
		tiles = { def.image },
		drawtype = "signlike",
		paramtype = "light",
		paramtype2 = "wallmounted",
		place_param2 = 1,
		is_ground_content = false,
		floodable = true,
		on_flood = function(pos, oldnode, newnode)
			-- Node is destroyed if flooded by lava.
			-- If flooded by anything else, drops as item.
			if minetest.get_item_group(newnode.name, "lava") == 0 then
				minetest.add_item(pos, oldnode.name)
			end
		end,
		sounds = hades_sounds.node_sound_stone_defaults(),
		groups = {dig_immediate=3, attached_node=1, eatable=def.eatable, food=def.food},
		on_use = on_use,
		on_rotate = false,
		walkable = false,
		selection_box = {
			type = "wallmounted",
		},
		stack_max = stack_max or def.stack_max,
	})
end

-- ITEMS

register_plate("hades_food:plate", {
	description = S("Plate"),
	image = "hades_food_plate.png"
})

minetest.register_craftitem("hades_food:pie_strawberry_raw", {
	description = S("Raw Strawberry Pie"),
	inventory_image = "hades_food_strawberry_pie_raw.png",
	on_use = minetest.item_eat(1),
	groups = { food = 2, eatable = 1 },
})

minetest.register_craftitem("hades_food:pie_strawberry", {
	description = S("Strawberry Pie"),
	inventory_image = "hades_food_strawberry_pie.png",
	on_use = minetest.item_eat(5),
	groups = { food = 2, eatable = 5 },
})

hades_vessels.register_bottle("hades_food:bottle_olive_oil", {
	description = S("Bottle of Plant Oil"),
	tiles = {"hades_food_bottle_plant_oil.png"},
	inventory_image = "hades_food_bottle_plant_oil.png",
	wield_image = "hades_food_bottle_plant_oil.png",
	food=3,
	eatable=1,
})

hades_vessels.register_bottle("hades_food:bottle_coconut_milk", {
	description = S("Bottle of Coconut Milk"),
	tiles = {"hades_food_bottle_coconut_milk.png"},
	inventory_image = "hades_food_bottle_coconut_milk.png",
	wield_image = "hades_food_bottle_coconut_milk.png",
	food=3,
	eatable=3,
})

register_plate("hades_food:tomatosalad", {
	description = S("Tomato Salad"),
	image = "hades_food_tomatosalad.png",
	food = 2,
	eatable = 6,
})

register_plate("hades_food:tomato_potato_salad", {
	description = S("Tomato-Potato Salad"),
	image = "hades_food_tpsalad.png",
	food = 2,
	eatable = 10,
})

register_plate("hades_food:hearty_rice_dish", {
	description = S("Hearty Rice Dish"),
	image = "hades_food_hearty_rice_dish.png",
	food = 2,
	eatable = 5,
})

register_plate("hades_food:3_seasons_stew", {
	description = S("Three Seasons Stew"),
	image = "hades_food_3_seasons_stew.png",
	food = 2,
	eatable = 8,
})

minetest.register_craftitem("hades_food:spiced_potato", {
	description = S("Spiced Potato"),
	inventory_image = "hades_food_spiced_potato.png",
	on_use = minetest.item_eat(0),
	groups = { food = 2 },
})

minetest.register_craftitem("hades_food:baked_potato", {
	description = S("Baked Potato"),
	inventory_image = "hades_food_baked_potato.png",
	on_use = minetest.item_eat(3),
	groups = { food = 2, eatable = 3 },
})

minetest.register_craftitem("hades_food:pie_apple_raw", {
	description = S("Raw Apple Pie"),
	inventory_image = "hades_food_apple_pie_raw.png",
	on_use = minetest.item_eat(2),
	groups = { food = 2, eatable = 2 },
})

minetest.register_craftitem("hades_food:pie_apple", {
	description = S("Apple Pie"),
	inventory_image = "hades_food_apple_pie.png",
	on_use = minetest.item_eat(6),
	groups = { food = 2, eatable = 6 },
})

minetest.register_craftitem("hades_food:pie_orange_raw", {
	description = S("Raw Orange Pie"),
	inventory_image = "hades_food_orange_pie_raw.png",
	on_use = minetest.item_eat(2),
	groups = { food = 2, eatable = 2 },
})

minetest.register_craftitem("hades_food:pie_orange", {
	description = S("Orange Pie"),
	inventory_image = "hades_food_orange_pie.png",
	on_use = minetest.item_eat(7),
	groups = { food = 2, eatable = 7 },
})

minetest.register_craftitem("hades_food:chocolate_bar", {
	description = S("Chocolate Bar"),
	inventory_image = "hades_food_chocolate_bar.png",
	on_use = minetest.item_eat(4),
	groups = { food = 2, eatable = 4 },
})

-- CRAFTING

minetest.register_craft({
	output = 'hades_food:pie_strawberry_raw',
	recipe = {
		{'', 'hades_core:sugar', ''},
		{'hades_farming:strawberry', 'hades_farming:strawberry', 'hades_farming:strawberry'},
		{'hades_core:sugar', 'hades_farming:flour', 'hades_core:sugar'},
	}
})

minetest.register_craft({
	type = "cooking",
	output = "hades_food:pie_strawberry",
	recipe = "hades_food:pie_strawberry_raw",
	cooktime = 10,
})

minetest.register_craft({
	output = 'hades_food:pie_apple_raw',
	recipe = {
		{'', 'hades_core:sugar', ''},
		{'hades_trees:apple', 'hades_trees:apple', 'hades_trees:apple'},
		{'hades_core:sugar', 'hades_farming:flour', 'hades_core:sugar'},
	}
})

minetest.register_craft({
	type = "cooking",
	output = "hades_food:pie_apple",
	recipe = "hades_food:pie_apple_raw",
	cooktime = 10,
})

minetest.register_craft({
	output = 'hades_food:pie_orange_raw',
	recipe = {
		{'', 'hades_core:sugar', ''},
		{'hades_trees:orange', 'hades_trees:orange', 'hades_trees:orange'},
		{'hades_core:sugar', 'hades_farming:flour', 'hades_core:sugar'},
	}
})

minetest.register_craft({
	type = "cooking",
	output = "hades_food:pie_orange",
	recipe = "hades_food:pie_orange_raw",
	cooktime = 10,
})

minetest.register_craft({
	output = 'hades_food:bottle_olive_oil',
	recipe = {
		{'hades_core:cactus_fig', 'hades_core:cactus_fig', 'hades_core:cactus_fig'},
		{'hades_core:cactus_fig', 'hades_core:cactus_fig', 'hades_core:cactus_fig'},
		{'', 'hades_vessels:glass_bottle', ''},
	}
})
minetest.register_craft({
	output = 'hades_food:bottle_olive_oil',
	recipe = {
		{'hades_trees:olive', 'hades_trees:olive', 'hades_trees:olive'},
		{'', 'hades_vessels:glass_bottle', ''},
	}
})
minetest.register_craft({
	output = 'hades_food:bottle_coconut_milk',
	recipe = {
		{'hades_trees:coconut_seed'},
		{'hades_vessels:glass_bottle'},
	}
})

minetest.register_craft({
	output = 'hades_food:tomatosalad 2',
	recipe = {
		{'hades_farming:spice', 'hades_food:bottle_olive_oil', 'hades_farming:spice'},
		{'hades_farming:tomato', 'hades_farming:tomato', 'hades_farming:tomato'},
		{'hades_food:plate', 'hades_farming:bread', 'hades_food:plate'},
	},
	replacements = {
		{'hades_food:bottle_olive_oil', 'hades_vessels:glass_bottle'},
	}
})

minetest.register_craft({
	type = "shapeless",
	output = 'hades_food:tomato_potato_salad',
	recipe = {'hades_food:tomatosalad', 'hades_food:baked_potato'},
})

minetest.register_craft({
	type = "shapeless",
	output = 'hades_food:spiced_potato',
	recipe = {'hades_farming:spice', 'hades_farming:potato'},
})

minetest.register_craft({
	type = "cooking",
	cooktime = 10,
	output = "hades_food:baked_potato",
	recipe = "hades_food:spiced_potato",
})

minetest.register_craft({
	output = 'hades_food:plate 10',
	recipe = {
		{'', 'hades_core:clay', ''},
		{'hades_core:clay', 'hades_core:clay', 'hades_core:clay'},
		{'', 'hades_core:clay', ''},
	}
})

minetest.register_craft({
	output = 'hades_food:hearty_rice_dish',
	recipe = {
		{'hades_farming:bell_pepper', 'hades_farming:spice', 'hades_farming:bell_pepper'},
		{'', 'hades_farming:rice', ''},
		{'', 'hades_food:plate', ''},
	},
})

minetest.register_craft({
	output = 'hades_food:3_seasons_stew',
	recipe = {
		{'hades_farming:cabbage','hades_farming:bell_pepper','hades_farming:parsnip'},
		{'','hades_food:plate',''},
	},
})

minetest.register_craft({
	type = "shapeless",
	output = 'hades_food:chocolate_bar',
	recipe = {'hades_trees:cocoa_beans', 'hades_trees:cocoa_beans', 'hades_trees:cocoa_beans', 'hades_core:sugar'},
})


