# Hunger for Hades Revisited [`hades_hunger`]

This mod adds a mechanic for hunger.

This mod depends on the HUD bars mod [`hudbars`], version 1.4.1 or any later version starting with “1.” or “2.”.

## About hunger
This mod adds a hunger mechanic to the game. Players get an attribute called “satiation”:

* A new player starts with 20 satiation points out of 20
* Actions like digging, placing and walking cause exhaustion, which lower the satiation
* Every 800 seconds you lose 1 satiation point without doing anything
* At 0 satiation you will suffer damage and die in case you don't eat something
* If your satiation is 16 or higher, you will slowly regenerate health points
* Eating food will increase your satiation (Duh!)

Note: Eating food will not directly increase your health.

## Supported foods / technical background

All mods which add food through standard measures (calling `minetest.item_eat`) are supported.

This mod overwrites `minetest.item_eat` and reinterprets the `hp_change` argument as satiation points.
When this function is called, the player’s satiation points are increased by `hp_change`,
but `hp_change` will no longer affect the health.

It is recommended that all food items follow these conventions:

* In `on_use`, call `minetest.item_eat` like usual
* Add the `food` group with the appropriate rating:
    * `2` for eatable foods
    * `3` for drinks
    * `1` for other/unclassifiable stuff
* Add the `eatable` group with the rating being equal to the `hp_change` argument in `minetest.item_eat`

The `food` group is used to identify foods and its type. Drinks make a different sound. The `eatable` group is purely informative to inform other mods about the food’s satiation.
If the `hp_change` is 0, the `eatable` group may be omitted in the groups list.

## Licensing

This mod is free software.

### Source code

* License: [LGPL v2.1](https://www.gnu.org/licenses/old-licenses/lgpl-2.1.en.html)
* Author: by Wuzzy (2015-2016)
* Forked from the “Better HUD (and hunger)” mod by BlockMen (2013-2015),
  most code comes from this mod.

### Textures

* `hades_hunger_icon.png`—PilzAdam ([MIT License](https://opensource.org/licenses/MIT)), modified by BlockMen
* `hades_hunger_bgicon.png`—PilzAdam (MIT License), modified by BlockMen
* `hades_hunger_bar.png`—Wuzzy (MIT License)
* `survival_thirst_drink.ogg`—(MIT License)
* Everything else: MIT License, by BlockMen and Wuzzy

