local S = minetest.get_translator("hades_trees")

local function generate_cocoatree(pos, check_light, override_trunk, override_leaves, replacements, override_fruit)
	hades_trees.generate_tree_variant({
		{ hades_trees.generate_tree_schematic, { pos, minetest.get_modpath("hades_trees").."/schems/hades_trees_cocoa_tree.mts", check_light, "hades_trees:cocoa_tree", "hades_trees:cocoa_leaves", "hades_refruit:bud_cocoa", override_trunk, override_leaves, override_fruit } },
		{ hades_trees.generate_tree_schematic, { pos, minetest.get_modpath("hades_trees").."/schems/hades_trees_cocoa_tree_small.mts", check_light, "hades_trees:cocoa_tree", "hades_trees:cocoa_leaves", "hades_refruit:bud_cocoa", override_trunk, override_leaves, override_fruit } },
	})
end

hades_trees.register_trunk("cocoa_tree", {
	description = S("Cocoa Tree Trunk"),
	tiles = {"hades_trees_cocoa_tree_top.png", "hades_trees_cocoa_tree_top.png", "hades_trees_cocoa_tree.png"},
})
hades_trees.register_bark("cocoa_bark", {
	description = S("Cocoa Bark"),
	image = "hades_trees_cocoa_tree.png",
})
hades_trees.register_leaves("cocoa_leaves", {
	description = S("Cocoa Leaves"),
	image = "hades_trees_cocoa_leaves_colorable.png",
	colorable = true,
	palette = "hades_trees_cocoa_leaves_palette.png",
	color_stereotype = "#60b555",
	ash_fertilizer = 3,
	trunk = "hades_trees:cocoa_tree",
})

hades_trees.register_sapling("cocoa_sapling", {
	description = S("Cocoa Tree Sapling"),
	image = "hades_trees_cocoa_sapling.png",
	selbox = {-0.3, -0.5, -0.3, 0.3, 0.35, 0.3},
	grow = generate_cocoatree,
	fruit = "hades_trees:cocoa_pod",
	fruit_chance = 12,
})
hades_trees.register_fruit("cocoa_pod", {
	description = S("Cocoa Pod"),
	drawtype = "plantlike",
	image = "hades_trees_cocoa_pod.png",
	selbox = {-5/16, -7/16, -5/16, 5/16, 0.5, 5/16},
	sounds = hades_sounds.node_sound_wood_defaults(),
})

hades_trees.register_seed("cocoa_beans", {
	description = S("Cocoa Beans"),
	image = "hades_trees_cocoa_beans.png",
	_hades_grows_to = "hades_trees:cocoa_sapling",
})

hades_trees.register_grow_abms({
	label = "Grow cocoa sapling and seed",
	sapling = "hades_trees:cocoa_sapling",
	seed = "hades_trees:cocoa_beans",
	interval = 30,
	chance = 20,
})

minetest.register_alias("hades_trees:cocoa_bean", "hades_trees:cocoa_beans")
