local S = minetest.get_translator("hades_trees")

local function generate_olivetree(pos, check_light, override_trunk, override_leaves, replacements, override_fruit)
	hades_trees.generate_tree_variant({
		{ hades_trees.generate_tree_schematic, { pos, minetest.get_modpath("hades_trees").."/schems/hades_trees_olive_tree.mts", check_light, "hades_trees:olive_tree", "hades_trees:olive_leaves", "hades_refruit:bud_olive", override_trunk, override_leaves, override_fruit } },
		{ hades_trees.generate_tree_schematic, { pos, minetest.get_modpath("hades_trees").."/schems/hades_trees_olive_tree_small.mts", check_light, "hades_trees:olive_tree", "hades_trees:olive_leaves", "hades_refruit:bud_olive", override_trunk, override_leaves, override_fruit } },
	})
end

hades_trees.register_trunk("olive_tree", {
	description = S("Olive Tree Trunk"),
	tiles = {"hades_trees_olive_tree_top.png", "hades_trees_olive_tree_top.png", "hades_trees_olive_tree.png"},
})
hades_trees.register_bark("olive_bark", {
	description = S("Olive Bark"),
	image = "hades_trees_olive_tree.png",
})
hades_trees.register_leaves("olive_leaves", {
	description = S("Olive Leaves"),
	image = "hades_trees_olive_leaves_colorable.png",
	overlay_image = "hades_trees_olive_leaves_overlay.png",
	colorable = true,
	palette = "hades_trees_olive_leaves_palette.png",
	color_stereotype = "#2c7d68",
	ash_fertilizer = 3,
	trunk = "hades_trees:olive_tree",
})
hades_trees.register_sapling("olive_sapling", {
	description = S("Olive Tree Sapling"),
	image = "hades_trees_olive_sapling.png",
	selbox = {-0.3, -0.5, -0.3, 0.3, 0.35, 0.3},
	grow = generate_olivetree,
	fruit = "hades_trees:olive",
	fruit_chance = 10,
})
hades_trees.register_seed("olive_seed", {
	description = S("Olive Seed"),
	image = "hades_trees_olive_seed.png",
	_hades_grows_to = "hades_trees:olive_sapling",
})


hades_trees.register_fruit("olive", {
	description = S("Olive"),
	drawtype = "plantlike",
	image = "hades_trees_olive.png",
	selbox = {-0.25, -7/16, -0.25, 0.25, 0.5, 0.25},
	satiation = 1,
})

hades_trees.register_grow_abms({
	label = "Grow olive sapling and seed",
	sapling = "hades_trees:olive_sapling",
	seed = "hades_trees:olive_seed",
	interval = 30,
	chance = 20,
})
