# Hades Revisited
Version 0.18.0

A game for Luanti, focused on terraforming and landscaping.
Based on *Minetest Hades* by Glünggi.

THIS IS A PREVIEW VERSION OF THE GAME. This game is playable,
but incomplete. Future versions might change a lot.

Requires Luanti version 5.10.0 or later.

## Introduction

Due to a gross miscalculation of the gravitational pull of the volcanic
planet Hades, the latest terraforming attempt of your space crew went
horribly wrong! You managed to survive, but it seems you are stranded
on this hellhole of a planet full of lava, stone and ash for good!

You still have a pickaxe and some apples. Also, water is hidden inside
the tall and chaotic stone spires. So your only chance of survival is to
search for water, use your crafting skills to form some soil and plant
apple trees. More plants might follow. The underground holds great riches,
but also great dangers. Lava is death. With your new acquired resources,
maybe, just maybe, you will turn Planet Hades into a nice, habitable place.

But beware: Many were not so lucky: Mutants will haunt on the surface and
who knows what dangers might hide in the deep underground?

## Installation

### Automatic installation with ContentDB
This is the easiest method.

This game is available in Luanti’s official ContentDB! If you have an
internet connection, just go into Luanti and browse the Content
section to install the latest and greatest version of the game.

### Manual installation
If for some reason you must install this game manually, just insert
the Hades Revisited directory into

    /games/hades_revisited

in the Luanti data folder.

## Important notices and short game guide

* Be sure the `minetest.conf` file in the main Luanti directory doesn’t have any parameters who are in conflict with the `minetest.conf` file from the `hades_revisited` directory. Especially mapgen parameters or stuff like `give_initial_stuff = false`
* There only 1 biome, with the focus on terraforming and landscaping
* Not everyone will like this game. But maybe there are some freaks out there ;-)

An attempt to colonize planet Hades went horribly wrong: Your exploration ship disintegrated and you survived with very limited supplies.
Hades is a very young planet and characterized by highly volcanic activities and a lot of fertile ash. Asteroids have brought some water on Hades.
So there are the basics for life, you just need to help it to get the nature going, make the planet habitable and survive.
Not every colonist has duly arrived. Most of them have been mutated and strayed around the planet.
There are creatures and most of them live in the underground and darkness.

## How to start:

You start with the following items: 1 steel pickaxe, 12 apples, 1 wall lamp and a stick.
Watch out for flowing lava above you at first!

Next you should dig some stone to craft a stone sword with the stick.
Now explore the area and search for some water.

Dig some stone and ash. Then craft volcanic sand from those items, then
craft fertile sand from volcanic sand and stone.

Place the fertile sand next to water and wait for it to become dirt.
Turn one of your apples into apple seeds in the crafting menu.
Plant it on dirt and wait for it to grow to an apple sapling, then an apple tree.
The apple tree takes some time to bear apples, but once it does, you can pluck them and either eat them or craft them to more seeds.
Punch the tree trunk to get it, use it to craft wood, a very useful resource.
Make more dirt and place it near water.

If you ran out of fruit and seeds, or lost your pickaxe, fight some mutants. They sometimes drop apples, pickaxes and other things.

Use 2 mossy cobblestone or mossy tuff (can be found near water) combine it with dirt to craft grass seeds.

Grass + dirt = tropical grass seeds.

Dig the grass and the tropical grass to get some new seeds. Read the tooltip to learn how they grow.

Some seeds need wet soil. To get wet soil, craft a hoe and use it on dirt to get normal soil, then put water nearby to make it wet.

Now you should know enough to survive. Use the crafting guide to find out more recipes.
Read the tooltips of new items carefully to learn how they work.

## Things you should know

### Block transformations

* Fertile sand turns into dirt in the near of 10 nodes to water and direct contact of a dirt.
* Volcanic ash turns into volcanic sand if leaves are nearby.
* Volcanic sand turns into fertile sand if leaves are nearby.
* Volcanic ash slowly turns into clay when next to water.
* Flowing water turns lava source into water source and flowing lava into volcanic gravel.
* Stone, tuff and cobblestone become burned when next to lava.
* Stone, tuff and cobblestone become mossy when next to water.
* Mossy cobblestone turns into gravel when next to flowing water.
* Chondrite turns into marble if it is below -500 and it must be in near 4 nodes to lava and it also must have direct contact to water.
* Volcanic gravel turns into obsidian below Y=-1000. It must have direct contact to lava and water and must be nearby.
* Sugarcane appears near papyrus. It doesn’t need water to grow, just dirt.
* Grass seeds on dirt slowly turn it into dirt with grass
* Grass seeds on dirt with grass grow grass clumps

### Other gameplay stuff

* There are 3 seasons: Spring, Summer and Fall. Each season has a different sky, and plants will grow differently in each season. The game starts in spring.
* There is no fire
* Beds let you set the spawn point, you can’t skip the night
* Volcanic gravel can only be dug by a shovel.
* Mobs spawn on stone, ash and tuff
* Tuff is too breakable for tools so it can’t be used to craft stone tools. Basalt, however, is fine.
* There are no buckets; you can transport water by using glass tanks
* Weak torches can be upgraded with a cotton (string) to bright torches
* Many plants grow with light level of 8 or higher. Underground farming is thus possible
* 2 emeralds = 1 sapphire. 2 sapphires = 1 ruby. 2 rubies = 1 diamond.
* With the Staff of Gaia you can turn following blocks into dirt: ash, volcanic sand, fertile sand, burned stone, stone, cobble, mossy stone, tuff, burned tuff, mossy tuff, mossy cobble
* Pale tree saplings can be planted on ash
* Cacti grow on ash (but sand is better)
* Prismatic furnace is faster than the regular furnace and has more slots
* You can center doors with the screwdriver

### Ores

Ores generate at and below the following altitudes:

    Coal . . . . . .    +60
    Iron:  . . . . .      0
    Copper:  . . . .   -115
    Tin: . . . . . .   -115
    Mese:  . . . . .   -200
    Gold:  . . . . .   -333
    Emerald: . . . .    +20
    Sapphire:  . . .   -300
    Ruby:  . . . . .   -900
    Diamond: . . . .  -1200

Craft an altimeter to learn your current altitude.

Maximum ore generation is at altitude of -10000 or below.

## Info for developers

If you’re a modder or game developer, please read `DEVELOPERS.md`.

## Used mods

This game is based on a lot of mods created by other people, mostly
from the Luanti community. Many such mods were heavily edited
to fit the game. For a list, see `MODS.md`.

## Licensing

Hades Revisited, a terraforming game
Copyright (C) 2017-2025  Wuzzy, Glünggi and contributors

This game is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This game is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

The media files are licensed under Creative Commons Attribution
ShareAlike 3.0 Unported.

Along with this game, you should have received a copy of
both licenses (see `LICENSE.txt`).
If not, see <https://www.gnu.org/licenses/>
and <https://creativecommons.org/licenses/>.

Additionally, some mods (in the `mods` directory) are
also available under other free software license terms.
For details, see the file `LICENSE.txt`.
