local S = minetest.get_translator("hades_columnia")
local F = minetest.formspec_escape

local STEREOTYPE = "hades_core_marble" -- example node to use for item image

local button_rows = {
	{ type = "caption", caption = S("Basics") },
	{ type = "buttons", buttons = { "bottom", "mid", "top", "crosslink" } },
	{ type = "caption", caption = S("Links") },
	{ type = "buttons", buttons = { "link", "linkcross", "linkangle", "linktee" } },
	{ type = "caption", caption = S("Links with Downs") },
	{ type = "buttons", buttons = { "linkdown", "linkcrossdown", "linkangle_down", "linktee_down", "linkvertical" } },
	{ type = "caption", caption = S("Stair Substructures") },
	{ type = "buttons", buttons = { "stairsub", "stairsubpillar" } },
}

local formspec_buttons = ""
do
	local y = 0
	for b=1, #button_rows do
		local brow = button_rows[b]
		if brow.type == "caption" then
			formspec_buttons = formspec_buttons .. "label[0,"..y..";"..F(brow.caption).."]"
			y = y + 0.25
		elseif brow.type == "buttons" then
			local x = 0
			for bu=1, #brow.buttons do
				local bid = brow.buttons[bu]
				formspec_buttons = formspec_buttons .. "item_image_button["..x..","..y..";1,1;hades_columnia:column_"..bid.."_"..STEREOTYPE..";column_"..bid..";]"
				x = x + 1.2
			end
			y = y + 1.4
		end
	end
end

local machine_formspec =
	"formspec_version[6]"..
	"size[12.75,12]"..
	"bgcolor[#00000000;neither]"..
	"background9[0,0;10,10;columnia_background.png;true;6]"..
	"list[current_name;ingot;10,5.7;1,1;]"..
	"list[current_name;res;11.2,5.7;1,1;]"..
	"label[10,5.2;"..F(S("Input:")).."]"..
	"label[11.2,5.2;"..F(S("Output:")).."]"..

	"container[0.475,0.475]"..
	formspec_buttons..
	"container_end[]"..

	"list[current_player;main;0.475,7;10,4;]"..

	"tooltip[column_bottom;"..F(S("Column Bottom")).."]"..
	"tooltip[column_mid;"..F(S("Column")).."]"..
	"tooltip[column_top;"..F(S("Column Top")).."]"..
	"tooltip[column_crosslink;"..F(S("Column Crosslink")).."]"..

	"tooltip[column_link;"..F(S("Column Link")).."]"..
	"tooltip[column_linkcross;"..F(S("Column Cross")).."]"..
	"tooltip[column_linkangle;"..F(S("Column Link Cross")).."]"..
	"tooltip[column_linktee;"..F(S("Column Link T-Form")).."]"..

	"tooltip[column_linkdown;"..F(S("Column Link Down")).."]"..
	"tooltip[column_linkcrossdown;"..F(S("Column Cross Down")).."]"..
	"tooltip[column_linkangle_down;"..F(S("Column Link Cross Down")).."]"..
	"tooltip[column_linktee_down;"..F(S("Column Link T-Form Down")).."]"..
	"tooltip[column_linkvertical;"..F(S("Column Link Vertical")).."]"..

	"tooltip[column_stairsub;"..F(S("Stair Substructure")).."]"..
	"tooltip[column_stairsubpillar;"..F(S("Stair Substructure Pillar")).."]"..

	"listring[current_player;main]"..
	"listring[current_name;ingot]"..
	"listring[current_player;main]"..
	"listring[current_name;res]"

local desc = S("Columnia Workstation")
minetest.register_node("hades_columnia:machine", {
	description = desc,
	_tt_help = S("Turns blocks to columns and more"),
	tiles = {
		"columnia_machine_top.png",
		"columnia_machine_bottom.png",
		"columnia_machine_side2.png",
		"columnia_machine_side1.png",
		"columnia_machine_back.png",
		"columnia_machine_front.png"
		},
	drawtype = "nodebox",
	paramtype = "light",
	paramtype2 = "facedir",
	is_ground_content = false,
	groups = {choppy=3, cracky=3, oddly_breakable_by_hand=2,owned=1},
	node_box = {
		type = "fixed",
		fixed = {
			{-0.5, -0.1875, -0.5, 0.5, -0.0625, 0.5},
			{-0.125, 0.0625, -0.125, 0.125, 0.5, 0.125},
			{-0.25, 0, -0.25, 0.25, 0.125, 0.25},
			{-0.4375, -0.5, -0.4375, -0.3125, -0.1875, -0.3125},
			{-0.4375, -0.5, 0.3125, -0.3125, -0.1875, 0.4375},
			{0.3125, -0.5, -0.4375, 0.4375, -0.1875, -0.3125},
			{0.3125, -0.5, 0.3125, 0.4375, -0.1875, 0.4375},
			{-0.1875, 0.125, -0.1875, 0.1875, 0.1875, 0.1875},
			{-0.1875, -0.0625, -0.3125, -0.125, 0, 0.3125},
			{0.125, -0.0625, -0.3125, 0.1875, 0, 0.3125},
			{-0.4375, -0.0625, -0.4375, -0.375, 0, -0.0625},
			{-0.375, -0.0625, -0.4375, -0.1875, 0, -0.375}, 
			{0.28125, -0.0625, 0.3125, 0.46875, 0.0625, 0.4375}, 
			{0.34375, -0.0625, -0.0625, 0.40625, 0, 0.4375},
		}
	},
	selection_box = {
		type = "fixed",
		fixed = {-0.5, -0.5, -0.5, 0.5, 0.0625, 0.5}
	},
	sounds = hades_sounds.node_sound_wood_defaults(),

	can_dig = function(pos,player)
		local meta = minetest.get_meta(pos);
		local inv = meta:get_inventory()
		if not inv:is_empty("ingot") then
			return false
		elseif not inv:is_empty("res") then
			return false
		end
		return true
	end,

	on_rotate = "simple",

	on_construct = function(pos)
		local meta = minetest.get_meta(pos)
		meta:set_string("formspec", machine_formspec)
		meta:set_string("infotext", S("Columnia Workstation"))
		local inv = meta:get_inventory()
		inv:set_size("ingot", 1)
		inv:set_size("res", 1)
	end,

	on_receive_fields = function(pos, formname, fields, sender)
		local meta = minetest.get_meta(pos)
		local inv = meta:get_inventory()

-----------------------------
if fields["column_bottom"] 
or fields["column_mid"]
or fields["column_top"]
or fields["column_crosslink"]
or fields["column_link"]
or fields["column_linkdown"]
or fields["column_linkcross"]
or fields["column_linkcrossdown"]
or fields["column_linkvertical"]
or fields["column_linkangle"]
or fields["column_linkangle_down"]
or fields["column_linktee"]
or fields["column_linktee_down"]
or fields["column_stairsub"]
or fields["column_stairsubpillar"]
then

--Crown Mould-----------------------------------------

	local material, shape
	local make_ok = false
	local anzahl

	if inv:is_empty("ingot") then
		return
	end

	if fields["column_bottom"] then
		anzahl = 1
		shape = "hades_columnia:column_bottom_"
	end

	if fields["column_mid"] then
		make_ok = false
		anzahl = 1
		shape = "hades_columnia:column_mid_"
	end

	if fields["column_top"] then
		anzahl = 1
		shape = "hades_columnia:column_top_"
	end

	if fields["column_crosslink"] then
		make_ok = false
		anzahl = 1
		shape = "hades_columnia:column_crosslink_"
	end

	if fields["column_link"] then
		anzahl = 2
		shape = "hades_columnia:column_link_"
	end

	if fields["column_linkdown"] then
		anzahl = 2
		shape = "hades_columnia:column_linkdown_"
	end

	if fields["column_linkcross"] then
		anzahl = 2
		shape = "hades_columnia:column_linkcross_"
	end

	if fields["column_linkcrossdown"] then
		anzahl = 2
		shape = "hades_columnia:column_linkcrossdown_"
	end

	if fields["column_linkvertical"] then
		anzahl = 4
		shape = "hades_columnia:column_linkvertical_"
	end

	if fields["column_linkangle"] then
		anzahl = 2
		shape = "hades_columnia:column_linkangle_"
	end

	if fields["column_linkangle_down"] then
		anzahl = 2
		shape = "hades_columnia:column_linkangle_down_"
	end

	if fields["column_linktee"] then
		anzahl = 2
		shape = "hades_columnia:column_linktee_"
	end

	if fields["column_linktee_down"] then
		anzahl = 2
		shape = "hades_columnia:column_linktee_down_"
	end

	if fields["column_stairsub"] then
		anzahl = 1
		shape = "hades_columnia:column_stairsub_"
	end

	if fields["column_stairsubpillar"] then
		anzahl = 1
		shape = "hades_columnia:column_stairsubpillar_"
	end

	local ingotstack = inv:get_stack("ingot", 1)
	local resstack = inv:get_stack("res", 1)

----------------------------------------------------------------------
--Register Items
----------------------------------------------------------------------

	if hades_columnia.registered_materials[ingotstack:get_name()] then
		material = hades_columnia.registered_materials[ingotstack:get_name()]
		make_ok = true
	end

	if make_ok == true then
		local output_item = shape..material
		if not inv:is_empty("res") and resstack:get_name() ~= output_item then
			return
		end

		local success = false
		for i = 0, anzahl-1 do
			local result = inv:add_item("res", output_item)
			if result ~= nil then
				success = true
			end
		end
		if success then
			ingotstack:take_item()
			inv:set_stack("ingot", 1, ingotstack)
		end
	end
end
end,

	-- Slight offset to avoid z-fighting with item frame
	_hades_itemshow_offset = { x=-0.01, y=0, z=-0.01 },
})

--Craft

minetest.register_craft({
	output = 'hades_columnia:machine',
	recipe = {
		{'hades_core:iron_ingot', 'hades_core:iron_ingot', 'hades_core:iron_ingot'},
		{'group:wood', 'hades_core:stone', 'group:wood'},
		{'hades_core:stone', "", 'hades_core:stone'},		
	},
})

minetest.register_lbm({
	name = "hades_columnia:update_meta_v0_19_0",
	label = "Update columnia workstation meta (v0.19.0)",
	nodenames = { "hades_columnia:machine" },
	action = function(pos)
		local meta = minetest.get_meta(pos)
		meta:set_string("formspec", machine_formspec)
		meta:set_string("infotext", S("Columnia Workstation"))
		meta:set_string("owner", "")
	end,
})
