local S = minetest.get_translator("hades_trees")

hades_trees.register_trunk("charred_tree", {
	description = S("Charred Tree Trunk"),
	tiles = {
		"hades_trees_charred_tree_top.png",
		"hades_trees_charred_tree_top.png",
		"hades_trees_charred_tree.png",
	},
	sounds = hades_sounds.node_sound_wood_defaults({pitch=0.8}),
	is_flammable = false,
})
hades_trees.register_bark("charred_bark", {
	description = S("Charred Bark"),
	image = "hades_trees_charred_tree.png",
	sounds = hades_sounds.node_sound_wood_defaults({pitch=0.8}),
	is_flammable = false,
})

hades_trees.register_leaves("burned_branches", {
	description = S("Burned Branches"),
	image = "hades_trees_burned_branches.png",
	sounds = hades_sounds.node_sound_straw_defaults(),
	-- Can survive near any trunk
	leafdecay_any = 1,
	trunk = "hades_trees:charred_tree",
})

minetest.register_craft({
	output = "hades_core:stick 2",
	recipe = {{ "hades_trees:burned_branches" }},
})

minetest.register_craft({
	output = "hades_trees:charred_wood",
	recipe = {{ "hades_trees:charred_tree" }},
})

minetest.register_abm({
	label = "Scorch tree trunks and leaves (near)",
	nodenames = {"group:tree", "group:leaves"},
	neighbors  = {"group:lava"},
	interval = 20,
	chance = 20,
	action = function(pos, node)
		if minetest.get_item_group(node.name, "tree") ~= 0 then
			if node.name ~= "hades_trees:charred_tree" then
				minetest.set_node(pos, {name="hades_trees:charred_tree"})
			end
		elseif minetest.get_item_group(node.name, "leaves") ~= 0 then
			if node.name ~= "hades_trees:burned_branches" then
				minetest.set_node(pos, {name="hades_trees:burned_branches"})
			end
		end
	end,
})

-- Scorches tree trunks and leaves by lava.
-- This simulates the "heat" of lava rising up, damaging
-- trees
minetest.register_abm({
	label = "Scorch tree trunks and leaves (far)",
	nodenames = {"group:tree", "group:leaves"},
	interval = 29,
	chance = 40,
	action = function(pos, node)
		local minpos = vector.add(pos, vector.new(-2, -6, -2))
		local maxpos = vector.add(pos, vector.new(2, 2, 2))
		local lavas = minetest.find_nodes_in_area(minpos, maxpos, {"group:lava"})
		if #lavas == 0 then
			return
		end
		local lava = lavas[math.random(1, #lavas)]
		local lminpos = vector.add(lava, vector.new(-2, -2, -2))
		local lmaxpos = vector.add(lava, vector.new(2, 6, 2))
		local posses = minetest.find_nodes_in_area(lminpos, lmaxpos, {"group:tree", "group:leaves"})
		local lowest_trunk_pos, lowest_leaves_pos
		-- Checks if nodes between plant_pos and lava_pos are "free" for the heat to rise
		local free_path = function(plant_pos, lava_pos)
			local ppy = plant_pos.y
			local lpy = lava_pos.y
			if ppy == lpy then
				return true
			else
				local step
				if ppy < lpy then
					step = 1
				else
					step = -1
				end
				for y=ppy, lpy, step do
					local tpos = vector.new(plant_pos.x, y, plant_pos.z)
					local tn = minetest.get_node(tpos).name
					if y ~= ppy and (y ~= lpy and not vector.equals(lava_pos, tpos)) and tn ~= "air" and minetest.get_item_group(tn, "tree") == 0 and minetest.get_item_group(tn, "leaves") == 0 and minetest.get_item_group(tn, "lava") == 0 then
						return false
					end
				end
				return true
			end
		end
		for p=1, #posses do
			local mynode = minetest.get_node(posses[p])
			if minetest.get_item_group(mynode.name, "leaves") ~= 0 then
				if mynode.name ~= "hades_trees:burned_branches" and free_path(posses[p], lava) then
					if not lowest_leaves_pos or posses[p].y < lowest_leaves_pos.y then
						lowest_leaves_pos = posses[p]
					end
				end
			elseif minetest.get_item_group(mynode.name, "tree") ~= 0 then
				if mynode.name ~= "hades_trees:charred_tree" and free_path(posses[p], lava) then
					if not lowest_trunk_pos or posses[p].y < lowest_trunk_pos.y then
						lowest_trunk_pos = posses[p]
					end
				end
			end
		end
		if lowest_trunk_pos and lowest_leaves_pos then
			if lowest_trunk_pos.y < lowest_leaves_pos.y then
				minetest.set_node(lowest_trunk_pos, {name="hades_trees:charred_tree"})
			else
				minetest.set_node(lowest_leaves_pos, {name="hades_trees:burned_branches"})
			end
		elseif lowest_leaves_pos then
			minetest.set_node(lowest_leaves_pos, {name="hades_trees:burned_branches"})
		elseif lowest_trunk_pos then
			minetest.set_node(lowest_trunk_pos, {name="hades_trees:charred_tree"})
		end
	end
})
