local S = minetest.get_translator("hades_trees")

local function generate_bananatree(pos, check_light, override_trunk, override_leaves, replacements, override_fruit)
	hades_trees.generate_tree_variant({
		{ hades_trees.generate_tree_schematic, { pos, minetest.get_modpath("hades_trees").."/schems/hades_trees_banana_tree.mts", check_light, "hades_trees:banana_tree", "hades_trees:banana_leaves", "hades_refruit:bud_banana", override_trunk, override_leaves, override_fruit } },
		{ hades_trees.generate_tree_schematic, { pos, minetest.get_modpath("hades_trees").."/schems/hades_trees_banana_tree_small.mts", check_light, "hades_trees:banana_tree", "hades_trees:banana_leaves", "hades_refruit:bud_banana", override_trunk, override_leaves, override_fruit } },
	})
end

hades_trees.register_trunk("banana_tree", {
	description = S("Banana Tree Trunk"),
	tiles = {"hades_trees_banana_tree_top.png", "hades_trees_banana_tree_top.png", "hades_trees_banana_tree.png"},
})
hades_trees.register_bark("banana_bark", {
	description = S("Banana Bark"),
	image = "hades_trees_banana_tree.png",
})

hades_trees.register_leaves("banana_leaves", {
	description = S("Banana Leaves"),
	image = "hades_trees_banana_leaves_colorable.png",
	colorable = true,
	palette = "hades_trees_banana_leaves_palette.png",
	color_stereotype = "#43873b",
	ash_fertilizer = 3,
	trunk = "hades_trees:banana_tree",
})
hades_trees.register_sapling("banana_sapling", {
	description = S("Banana Sapling"),
	image = "hades_trees_banana_sapling.png",
	selbox = {-0.3, -0.5, -0.3, 0.3, 0.35, 0.3},
	grow = generate_bananatree,
	fruit = "hades_trees:banana",
	fruit_chance = 9,
})
hades_trees.register_seed("banana_seed", {
	description = S("Banana Seed"),
	image = "hades_trees_banana_seed.png",
	_hades_grows_to = "hades_trees:banana_sapling",
})


hades_trees.register_fruit("banana", {
	description = S("Banana"),
	drawtype = "torchlike",
	image = "hades_trees_banana.png",
	selbox = {-4/16, -7/16, -4/16, 4/16, 6/16, 4/16},
	satiation = 2,
})


hades_trees.register_grow_abms({
	label = "Grow banana sapling and seed",
	sapling = "hades_trees:banana_sapling",
	seed = "hades_trees:banana_seed",
	interval = 30,
	chance = 10,
})
