local S = minetest.get_translator("hades_flowers")

hades_flowers = {}

-- See README.txt for licensing and other information.

local flowers = {
	{ "white", S("White Flower"), S("White Flower Seedling"), S("White Flower Seed"), { -0.15, -0.5, -0.15, 0.15, 0.2, 0.15 }, { -0.15, -0.5, -0.15, 0.15, 0, 0.15 }},
	{ "red", S("Red Flower"), S("Red Flower Seedling"), S("Red Flower Seed"), { -0.15, -0.5, -0.15, 0.15, 0.3, 0.15 }, { -0.15, -0.5, -0.15, 0.15, 0, 0.15 } },
	{ "orange",
		--~ A flower that has the color orange
		S("Orange Flower"),
		--~ A seedling for a flower that has the color orange
		S("Orange Flower Seedling"),
		--~ Seed for a flower that has the color orange
		S("Orange Flower Seed"), { -0.15, -0.5, -0.15, 0.15, 0.25, 0.15 }, { -0.15, -0.5, -0.15, 0.15, 0, 0.15 }},
	{ "yellow", S("Yellow Flower"), S("Yellow Flower Seedling"), S("Yellow Flower Seed"), { -0.27, -0.5, -0.27, 0.27, 0.2, 0.27 }, { -0.15, -0.5, -0.15, 0.15, 0, 0.15 } },
	{ "blue", S("Blue Flower"), S("Blue Flower Seedling"), S("Blue Flower Seed"), { -0.175, -0.5, -0.175, 0.175, 0.35, 0.175 }, { -0.15, -0.5, -0.15, 0.15, 0, 0.15 } },
	{ "violet", S("Violet Flower"), S("Violet Flower Seedling"), S("Violet Flower Seed"), { -0.15, -0.5, -0.15, 0.15, 0.2, 0.15 }, { -0.15, -0.5, -0.15, 0.15, 0, 0.15 } },
}

for f=1, #flowers do
	local color = flowers[f][1]
	local desc_flower = flowers[f][2]
	local desc_seedling = flowers[f][3]
	local desc_seed = flowers[f][4]
	local selbox_flower = flowers[f][5]
	local selbox_seedling = flowers[f][6]

	hades_groundplants.register_groundplant("hades_flowers", color, {
		description = desc_flower,
		stages = {
			{
				description = desc_seedling,
				_tt_help = S("Grows on dirt in light").."\n"..S("Blooms in spring and summer"),
				tiles = { "hades_flowers_seedling_"..color..".png" },
				image = "hades_flowers_seedling_"..color..".png",
				selection_box = {
					type = "fixed",
					fixed = selbox_seedling,
				},
				in_creative_inventory = false,
			},
			{
				description = desc_flower,
				_tt_help = S("Lives on dirt or clay").."\n"..S("Blooms in spring and summer"),
				tiles = { "hades_flowers_"..color..".png" },
				image = "hades_flowers_"..color..".png",
				selection_box = {
					type = "fixed",
					fixed = selbox_flower,
				},
				extra_groups = { flower_spread = 1 },
				in_creative_inventory = true,
			},
		},
		sounds = hades_sounds.node_sound_grass_defaults(),
		groups = {snappy=3, flammable=2, attached_node=1, ["color_"..color]=1 },
		stage_groups = { "flower" },
	})

	hades_seeds.register_seed("hades_flowers:seed_"..color, {
		description = desc_seed,
		_tt_help = S("Grows on dirt in light").."\n"..S("Seasons: Spring, Summer"),
		image = "hades_flowers_seed_"..color..".png",
		surface_check = function(node)
			return minetest.get_item_group(node.name, "dirt") ~= 0 or node.name == "hades_furniture:plant_pot"
		end,
		extra_groups = { seed_flower = 1 },
		_hades_grows_to = "hades_flowers:"..color.."_1",
	})
end

minetest.register_node("hades_flowers:dead", {
	description = S("Dead Flower"),
	drawtype = "plantlike",
	tiles = { "hades_flowers_dead.png" },
	use_texture_alpha = "clip",
	inventory_image = "hades_flowers_dead.png",
	wield_image = "hades_flowers_dead.png",
	waving = 1,
	sunlight_propagates = true,
	paramtype = "light",
	walkable = false,
	buildable_to = true,
	floodable = true,
	groups = {snappy=3, flammable=2, attached_node=1},
	sounds = hades_sounds.node_sound_grass_defaults(),
	drop = "",
	selection_box = {
		type = "fixed",
		fixed = { -0.15, -0.5, -0.15, 0.15, 0, 0.15 },
	},
})

minetest.register_abm({
	label = "Grow flower seeds and seedlings in light",
	nodenames = {"group:seed_flower", "group:flower"},
	interval = 10,
	chance = 25,
	action = function(pos, node)
		local light = minetest.get_node_light(pos)
		if light < 8 then
			return
		end
		local g_seed = minetest.get_item_group(node.name, "seed_flower")
		local g_flower = minetest.get_item_group(node.name, "flower")

		local split = node.name:split(":")
		local mname = split[1]
		local pname = split[2]

		local below = {x=pos.x, y=pos.y-1, z=pos.z}
		local bnode = minetest.get_node(below)
		-- Die if not on dirt, clay or plant pot
		local on_soil = minetest.get_item_group(bnode.name, "dirt") ~= 0 or bnode.name == "hades_furniture:plant_pot"
		if not on_soil then
			if bnode.name ~= "hades_core:clay" then
				if g_flower ~= 0 then
					minetest.set_node(pos, {name="hades_flowers:dead"})
				else
					minetest.remove_node(pos)
				end
				return
			end
		end

		local season = hades_seasons.get_season()

		if g_seed ~= 0 then
			-- Grow seed in spring or summer
			if on_soil and season == hades_seasons.SEASON_SPRING or season == hades_seasons.SEASON_SUMMER then
				local fname = mname .. ":" .. pname:gsub("seed_", "")
				fname = fname .. "_1"
				local below = {x=pos.x, y=pos.y-1, z=pos.z}
				local bnode = minetest.get_node(below)
				minetest.set_node(pos, {name = fname, param2 = 0})
			end
		elseif g_flower == 1 then
			-- Grow seedling in spring or summer
			if on_soil then
				local fname = mname .. ":" .. pname:gsub("_%d+", "")
				fname = fname .. "_2"
				if season == hades_seasons.SEASON_SPRING or season == hades_seasons.SEASON_SUMMER then
					minetest.set_node(pos, {name = fname, param2 = 0})
				end
			end
		elseif g_flower == 2 then
			-- Return flower to seedling stage in fall.
			-- (when fall ends, it can bloom again)
			local fname = mname .. ":" .. pname:gsub("_%d+", "")
			fname = fname .. "_1"
			if season == hades_seasons.SEASON_FALL then
				minetest.set_node(pos, {name = fname, param2 = 0})
			end
		end
	end
})

-- Called by the flower spreading ABM, parameters are the same as
-- the ABM's `action` argument.
-- This function can be overridden by external mods if they depending on this mod.
hades_flowers.flower_spread = function(pos, node, active_object_count, active_object_count_wider)
	if hades_seasons.get_season() ~= hades_seasons.SEASON_SPRING then
		return
	end
	pos.y = pos.y - 1
	local under = minetest.get_node(pos)
	pos.y = pos.y + 1
	if under.name ~= "hades_core:dirt_with_grass" then
		return
	end

	local light = minetest.get_node_light(pos)
	if not light or light < 8 then
		return
	end

	local pos0 = {x=pos.x-4,y=pos.y-4,z=pos.z-4}
	local pos1 = {x=pos.x+4,y=pos.y+4,z=pos.z+4}

	local hades_flowers = minetest.find_nodes_in_area(pos0, pos1, "group:flower_spread")
	if #hades_flowers > 3 then
		return
	end

	local seedlings = minetest.find_nodes_in_area(pos0, pos1, "hades_core:dirt_with_grass")
	if #seedlings > 0 then
		local seedling_pos = seedlings[math.random(#seedlings)]
		seedling_pos.y = seedling_pos.y + 1
		light = minetest.get_node_light(seedling_pos)
		if not light or light < 8 then
			return
		end
		if minetest.get_node(seedling_pos).name == "air" then
			local newnode = hades_groundplants.get_new_stage(node.name, 1)
			if newnode then
				minetest.set_node(seedling_pos, {name=newnode})
			end
		end
	end
end

minetest.register_abm({
	label = "Flower spreading",
	nodenames = {"group:flower_spread"},
	neighbors = {"hades_core:dirt_with_grass"},
	interval = 50,
	chance = 30,
	action = function(pos, node, active_object_count, active_object_count_wider)
		hades_flowers.flower_spread(pos, node, active_object_count, active_object_count_wider)
	end,
})

minetest.register_craft({
	output = 'hades_flowers:seed_white',
	recipe = {
		{'hades_farming:seed_cotton', 'hades_farming:seed_cotton', 'hades_farming:seed_cotton'},
		{'hades_grass:grass_1', 'hades_grass:grass_1', 'hades_grass:grass_1'},
		{'hades_core:dirt', 'hades_core:dirt', 'hades_core:dirt'},
	}
})
minetest.register_craft({
	output = 'hades_flowers:seed_yellow',
	recipe = {
		{'hades_flowers:white', 'hades_flowers:white', 'hades_flowers:white'},
		{'hades_grass:grass_1', 'hades_core:gold_lump', 'hades_grass:grass_1'},
		{'hades_core:dirt', 'hades_core:dirt', 'hades_core:dirt'},
	}
})
minetest.register_craft({
	output = 'hades_flowers:seed_red',
	recipe = {
		{'hades_flowers:white', 'hades_flowers:white', 'hades_flowers:white'},
		{'hades_grass:grass_1', 'hades_core:ruby', 'hades_grass:grass_1'},
		{'hades_core:dirt', 'hades_core:dirt', 'hades_core:dirt'},
	}
})
minetest.register_craft({
	output = 'hades_flowers:seed_violet',
	recipe = {
		{'hades_flowers:red', 'hades_flowers:red', 'hades_flowers:red'},
		{'hades_flowers:blue', 'hades_flowers:blue', 'hades_flowers:blue'},
		{'hades_core:dirt', 'hades_core:dirt', 'hades_core:dirt'},
	}
})
minetest.register_craft({
	output = 'hades_flowers:seed_blue',
	recipe = {
		{'hades_flowers:white', 'hades_flowers:white', 'hades_flowers:white'},
		{'hades_grass:grass_1', 'hades_core:sapphire', 'hades_grass:grass_1'},
		{'hades_core:dirt', 'hades_core:dirt', 'hades_core:dirt'},
	}
})
minetest.register_craft({
	output = 'hades_flowers:seed_orange',
	recipe = {
		{'hades_flowers:yellow', 'hades_flowers:yellow', 'hades_flowers:yellow'},
		{'hades_flowers:red', 'hades_flowers:red', 'hades_flowers:red'},
		{'hades_core:dirt', 'hades_core:dirt', 'hades_core:dirt'},
	}
})

-- Aliases for original flowers mod
minetest.register_alias("flowers:dandelion_white", "hades_flowers:white_2")
minetest.register_alias("flowers:dandelion_yellow", "hades_flowers:yellow_2")
minetest.register_alias("flowers:geranium", "hades_flowers:blue_2")
minetest.register_alias("flowers:rose", "hades_flowers:red_2")
minetest.register_alias("flowers:tulip", "hades_flowers:orange_2")
minetest.register_alias("flowers:viola", "hades_flowers:violet_2")
-- Aliases for old version of hades_flowers
minetest.register_alias("hades_flowers:white", "hades_flowers:white_2")
minetest.register_alias("hades_flowers:yellow", "hades_flowers:yellow_2")
minetest.register_alias("hades_flowers:blue", "hades_flowers:blue_2")
minetest.register_alias("hades_flowers:red", "hades_flowers:red_2")
minetest.register_alias("hades_flowers:orange", "hades_flowers:orange_2")
minetest.register_alias("hades_flowers:violet", "hades_flowers:violet_2")

