local S = minetest.get_translator("hades_trees")

-- The pale tree should have a special place in this game.
-- This is a tree with a very pale color, similar to the ashen
-- landscape, as if the tree has already adapted to the barren
-- wasteland.
-- It is very useful because it doesn’t need dirt to grow,
-- like most other trees, but its fruit doesn’t restore satiation.
-- It’s thus potentially a good candidate for an early-game
-- tree.

local function generate_paletree(pos, check_light, override_trunk, override_leaves, repl, override_fruit)
	override_trunk = override_trunk or "hades_trees:pale_tree"
	override_leaves = override_leaves or "hades_trees:pale_leaves"
	local underground = table.copy(hades_trees.DEFAULT_UNDERGROUND)
	table.insert(underground, "hades_core:ash")
	table.insert(underground, "hades_core:volcanic_sand")
	table.insert(underground, "hades_core:fertile_sand")
	local config = {
		trunk_height = 8,
		leaves_start_height = 2,
		leaves_height = 7,
		leaves_outwards = 1,
		leaves_chance_numerator = 2,
		leaves_chance_denominator = 5,
	}
	local replacement = repl or {
		name = "hades_refruit:bud_bland_fruit",
		chance = 20,
	}
	hades_trees.generate_tree_variant({
		{ hades_trees.generate_cuboid_tree, { pos, check_light, override_trunk, override_leaves, replacement, underground, config }},
		{ hades_trees.generate_tree_schematic, { pos, minetest.get_modpath("hades_trees").."/schems/hades_trees_pale_tree_small.mts", check_light, "hades_trees:pale_tree", "hades_trees:pale_leaves", "hades_refruit:bud_bland_fruit", override_trunk, override_leaves, override_fruit } },
	})
end

hades_trees.register_trunk("pale_tree", {
	--~ Trunk of the pale tree
	description = S("Pale Tree Trunk"),
	tiles = {"hades_trees_pale_tree_top.png", "hades_trees_pale_tree_top.png", "hades_trees_pale_tree.png"},
})
hades_trees.register_bark("pale_bark", {
	--~ Bark of the pale tree
	description = S("Pale Bark"),
	image = "hades_trees_pale_tree.png",
})
hades_trees.register_leaves("pale_leaves", {
	-- Note: The pale leaves intentionally don't use seasonal colors
	--~ Leaves of the pale tree
	description = S("Pale Leaves"),
	image = "hades_trees_pale_leaves.png",
	drop_item = "hades_trees:pale_seed",
	drop_rarity = 10,
	trunk = "hades_trees:pale_tree",
	leaves_group = "volcanic",
})
hades_trees.register_sapling("pale_sapling", {
	--~ Sapling of the pale tree
	description = S("Pale Tree Sapling"),
	image = "hades_trees_pale_sapling.png",
	selbox = {-0.3, -0.5, -0.3, 0.3, 0.35, 0.3},
	_growtype = "ash",
	grow = generate_paletree,
})
hades_trees.register_seed("pale_seed", {
	--~ Seed of the pale tree
	description = S("Pale Seed"),
	image = "hades_trees_pale_seed.png",
	_growtype = "ash",
	_hades_grows_to = "hades_trees:pale_sapling",
})
hades_trees.register_fruit("bland_fruit", {
	--~ Fruit of the pale tree. It has a bland taste
	description = S("Bland Fruit"),
	drawtype = "plantlike",
	image = "hades_trees_bland_fruit.png",
	selbox = {-0.225, -0.3125, -0.225, 0.225, 0.375, 0.225},
	satiation = 0,
})

hades_trees.register_grow_abms({
	label = "Grow pale sapling and seed",
	sapling = "hades_trees:pale_sapling",
	seed = "hades_trees:pale_seed",
	interval = 30,
	chance = 20,
	_growtype = "ash",
})
