local S = minetest.get_translator("hades_trees")

local generate_birchtree = function(pos, check_light, override_trunk, override_leaves, repl, override_fruit)
	override_trunk = override_trunk or "hades_trees:birch_tree"
	override_leaves = override_leaves or "hades_trees:birch_leaves"
	local config = {
		trunk_height = 7,
		leaves_start_height = 3,
		leaves_height = 7,
		leaves_outwards = 2,
		leaves_chance_numerator = 4,
		leaves_chance_denominator = 5,
	}
	local replacement = repl or {
		name = "hades_refruit:bud_birch_catkin",
		chance = 22,
	}
	hades_trees.generate_tree_variant({
		{ hades_trees.generate_cuboid_tree, { pos, check_light, override_trunk, override_leaves, replacement, nil, config }},
		{ hades_trees.generate_tree_schematic, { pos, minetest.get_modpath("hades_trees").."/schems/hades_trees_birch_tree_small.mts", check_light, "hades_trees:birch_tree", "hades_trees:birch_leaves", "hades_refruit:bud_birch_catkin", override_trunk, override_leaves, override_fruit } },
	})

end

hades_trees.register_trunk("birch_tree", {
	description = S("Birch Tree Trunk"),
	tiles = {"default_tree_birch_top.png", "default_tree_birch_top.png", "default_tree_birch.png"},
})
hades_trees.register_bark("birch_bark", {
	description = S("Birch Bark"),
	image = "default_tree_birch.png",
})
hades_trees.register_leaves("birch_leaves", {
	description = S("Birch Leaves"),
	image = "hades_trees_birch_leaves_colorable.png^hades_trees_birch_leaves_colorable_overlay.png",
	colorable = true,
	palette = "hades_trees_birch_leaves_palette.png",
	color_stereotype = "#95ea89",
	ash_fertilizer = 3,
	drop_item = "hades_trees:birch_seed",
	drop_rarity = 30,
	trunk = "hades_trees:birch_tree",
})
hades_trees.register_fruit("birch_catkin", {
	description = S("Birch Catkin"),
	leafdecay = 4,
	drawtype = "plantlike",
	image = "hades_trees_birch_catkin.png",
	selbox = {-0.3, -0.25, -0.325, 0.325, 0.5, 0.3},
})

hades_trees.register_sapling("birch_sapling", {
	description = S("Birch Sapling"),
	image = "default_sapling_birch.png",
	selbox = {-0.3, -0.5, -0.3, 0.3, 0.35, 0.3},
	grow = generate_birchtree,
})
hades_trees.register_seed("birch_seed", {
	description = S("Birch Seed"),
	image = "hades_trees_birch_seed.png",
	_hades_grows_to = "hades_trees:birch_sapling",
})
hades_trees.register_grow_abms({
	label = "Grow birch sapling and seed",
	sapling = "hades_trees:birch_sapling",
	seed = "hades_trees:birch_seed",
	interval = 30,
	chance = 20,
})
