local S = minetest.get_translator("hades_trees")

local function generate_appletree(pos, check_light, override_trunk, override_leaves, replacement, override_fruit)
	if not override_trunk then
		override_trunk = "hades_trees:tree"
	end
	if not override_leaves then
		override_leaves = "hades_trees:leaves"
	end
	hades_trees.generate_tree_variant({
		{ hades_trees.generate_applelike_tree, { pos, check_light, override_trunk, override_leaves, replacement } },
		{ hades_trees.generate_tree_schematic, { pos, minetest.get_modpath("hades_trees").."/schems/hades_trees_apple_tree_small.mts", check_light, "hades_trees:tree", "hades_trees:leaves", "hades_refruit:bud_apple", override_trunk, override_leaves, override_fruit } },
	})
end

hades_trees.register_trunk("tree", {
	description = S("Apple Tree Trunk"),
	tiles = {"default_tree_top.png", "default_tree_top.png", "default_tree.png"},
})
hades_trees.register_bark("bark", {
	description = S("Apple Bark"),
	image = "default_tree.png",
})

hades_trees.register_sapling("sapling", {
	description = S("Apple Sapling"),
	image = "default_sapling.png",
	selbox = {-0.3, -0.5, -0.3, 0.3, 0.35, 0.3},
	grow = generate_appletree,
	fruit = "hades_trees:apple",
	fruit_chance = 9,
})
hades_trees.register_seed("seed", {
	description = S("Apple Seed"),
	image = "hades_trees_seed.png",
	_hades_grows_to = "hades_trees:sapling",
})

hades_trees.register_leaves("leaves", {
	description = S("Apple Leaves"),
	image = "hades_trees_apple_leaves_colorable.png",
	ash_fertilizer = 3,
	trunk = "hades_trees:tree",
	colorable = true,
	palette = "hades_trees_apple_leaves_palette.png",
	color_stereotype = "#60b555",
})
hades_trees.register_fruit("apple", {
	description = S("Apple"),
	drawtype = "plantlike",
	image = "default_apple.png",
	selbox = {-0.25, -0.375, -0.25, 0.25, 0.375, 0.25},
	satiation = 2,
})

hades_trees.register_grow_abms({
	label = "Grow apple sapling and seed",
	sapling = "hades_trees:sapling",
	seed = "hades_trees:seed",
	interval = 10,
	chance = 50,
})


