local S = minetest.get_translator("hades_farming")
local NS = function(s) return s end

-- WHEAT
hades_farming.register_plant("hades_farming:wheat", {
	description_seed = S("Wheat Seed"),
	description_plant = S("Wheat Plant"),
	_tt_help = S("Grows on Wet Soil in light").."\n"..S("Seasons: Spring, Summer"),
	inventory_image = "hades_farming_wheat_seed.png",
	steps = 3,
	meshoptions = 3,
	seasons = { hades_seasons.SEASON_SPRING, hades_seasons.SEASON_SUMMER },
})
minetest.register_craftitem("hades_farming:wheat", {
	description = S("Wheat"),
	inventory_image = "hades_farming_wheat.png",
})
minetest.register_craftitem("hades_farming:flour", {
	description = S("Flour"),
	inventory_image = "hades_farming_flour.png",
})

minetest.register_craftitem("hades_farming:bread", {
	description = S("Bread"),
	inventory_image = "hades_farming_bread.png",
	on_use = minetest.item_eat(5),
	groups = { food = 2, eatable = 5 },
})

minetest.register_craft({
	type = "shapeless",
	output = "hades_farming:flour 1",
	recipe = {"hades_farming:seed_wheat", "hades_farming:seed_wheat", "hades_farming:seed_wheat", "hades_farming:seed_wheat", "hades_farming:seed_wheat", "hades_farming:seed_wheat", "hades_farming:seed_wheat", "hades_farming:seed_wheat", "hades_farming:seed_wheat"}
})

minetest.register_craft({
	type = "shapeless",
	output = "hades_farming:seed_wheat 3",
	recipe = {"hades_farming:wheat"}
})

minetest.register_craft({
	type = "cooking",
	cooktime = 15,
	output = "hades_farming:bread",
	recipe = "hades_farming:flour"
})

-- Straw
minetest.register_craft({
    type = "shapeless",
	output = "hades_farming:straw",
	recipe = {"hades_farming:wheat", "hades_farming:wheat", "hades_farming:wheat", "hades_farming:wheat"}
})

minetest.register_craft({
	output = "hades_farming:wheat 4",
	recipe = {
		{"hades_farming:straw"},
	}
})

-- RICE
hades_farming.register_plant("hades_farming:rice", {
	description_seed = S("Rice Seed"),
	description_plant = S("Rice Plant"),
	_tt_help = S("Grows on Wet Soil in light").."\n"..S("Seasons: Summer, Fall"),
	inventory_image = "hades_farming_rice_seed.png",
	steps = 3,
	meshoptions = 3,
	seasons = { hades_seasons.SEASON_SUMMER, hades_seasons.SEASON_FALL },
})
minetest.register_craftitem("hades_farming:rice", {
	description = S("Rice"),
	inventory_image = "hades_farming_rice.png",
})
minetest.register_craft({
	output = "hades_farming:rice_seed 3",
	recipe = {
		{"hades_farming:rice "},
	}
})

-- COTTON
hades_farming.register_plant("hades_farming:cotton", {
	description_seed = S("Cotton Seed"),
	description_plant = S("Cotton Plant"),
	_tt_help = S("Grows on Wet Soil in light").."\n"..S("All seasons"),
	description_harvest = S("String"),
	inventory_image = "hades_farming_cotton_seed.png",
	steps = 3,
	meshoptions = 0,
})
minetest.register_craftitem("hades_farming:cotton", {
	description = S("String"),
	inventory_image = "hades_farming_cotton.png",
})
minetest.register_craft({
	output = "hades_cloth:white",
	recipe = {
		{"hades_farming:cotton", "hades_farming:cotton"},
		{"hades_farming:cotton", "hades_farming:cotton"},
	}
})

minetest.register_alias("hades_farming:string", "hades_farming:cotton")

-- CABBAGE
hades_farming.register_plant("hades_farming:cabbage", {
	description_seed = S("Cabbage Seed"),
	description_plant = S("Cabbage Plant"),
	_tt_help = S("Grows on Wet Soil in light").."\n"..S("Season: Spring"),
	inventory_image = "hades_farming_cabbage_seed.png",
	steps = 3,
	meshoptions = 0,
	seasons = { hades_seasons.SEASON_SPRING },
})
minetest.register_craftitem("hades_farming:cabbage", {
	description = S("Cabbage"),
	inventory_image = "hades_farming_cabbage.png",
	groups = { food = 2, eatable = 3 },
	on_use = minetest.item_eat(3),
})
minetest.register_craft({
	output = 'hades_farming:seed_cabbage',
	recipe = {{'hades_farming:cabbage'},}
})

-- PARSNIP
hades_farming.register_plant("hades_farming:parsnip", {
	description_seed = S("Parsnip Seed"),
	description_plant = S("Parsnip Plant"),
	_tt_help = S("Grows on Wet Soil in light").."\n"..S("Season: Fall"),
	inventory_image = "hades_farming_parsnip_seed.png",
	steps = 3,
	meshoptions = 0,
	seasons = { hades_seasons.SEASON_FALL },
})
minetest.register_craftitem("hades_farming:parsnip", {
	description = S("Parsnip"),
	inventory_image = "hades_farming_parsnip.png",
	groups = { food = 2, eatable = 2 },
	on_use = minetest.item_eat(2),
})
minetest.register_craft({
	output = 'hades_farming:seed_parsnip',
	recipe = {{'hades_farming:parsnip'},}
})

-- TOMATO
hades_farming.register_plant("hades_farming:tomato", {
	description_seed = S("Tomato Seed"),
	description_plant = S("Tomato Plant"),
	_tt_help = S("Grows on Wet Soil in light").."\n"..S("Season: Summer"),
	inventory_image = "hades_farming_tomato_seed.png",
	steps = 3,
	meshoptions = 0,
	seasons = { hades_seasons.SEASON_SUMMER },
})
minetest.register_craftitem("hades_farming:tomato", {
	description = S("Tomato"),
	inventory_image = "hades_farming_tomato.png",
	groups = { food = 2, eatable = 2 },
	on_use = minetest.item_eat(2),
})
minetest.register_craft({
	output = 'hades_farming:seed_tomato',
	recipe = {{'hades_farming:tomato'},}
})

-- POTATO
hades_farming.register_plant("hades_farming:potato", {
	description_seed = S("Sprouting Potato"),
	description_plant = S("Potato Plant"),
	_tt_help = S("Grows on Wet Soil in light").."\n"..S("Season: Summer"),
	inventory_image = "hades_farming_potato_seed.png",
	steps = 3,
	meshoptions = 1,
	seasons = { hades_seasons.SEASON_SUMMER },
})
minetest.register_craftitem("hades_farming:potato", {
	description = S("Potato"),
	inventory_image = "hades_farming_potato.png",
	groups = { food = 2, },
	on_use = minetest.item_eat(0),
})
minetest.register_craft({
	output = 'hades_farming:seed_potato',
	recipe = {{'hades_farming:potato'},}
})

-- STRAWBERRY
hades_farming.register_plant("hades_farming:strawberry", {
	description_seed = S("Strawberry Seed"),
	description_plant = S("Strawberry Bush"),
	_tt_help = S("Grows on Wet Soil in light").."\n"..S("Season: Spring"),
	inventory_image = "hades_farming_strawberry_seed.png",
	steps = 3,
	meshoptions = 2,
	seasons = { hades_seasons.SEASON_SPRING },
})
minetest.register_craftitem("hades_farming:strawberry", {
	description = S("Strawberry"),
	inventory_image = "hades_farming_strawberry.png",
	groups = { food = 2, eatable = 1 },
	on_use = minetest.item_eat(1),
})
minetest.register_craft({
	output = 'hades_farming:seed_strawberry',
	recipe = {{'hades_farming:strawberry'},}
})

-- BELL PEPPER
hades_farming.register_plant("hades_farming:bell_pepper", {
	description_seed = S("Bell Pepper Seed"),
	description_plant = S("Bell Pepper Plant"),
	_tt_help = S("Grows on Wet Soil in light").."\n"..S("Season: Summer"),
	inventory_image = "hades_farming_bell_pepper_seed.png",
	steps = 3,
	meshoptions = 1,
	seasons = { hades_seasons.SEASON_SUMMER },
})
minetest.register_craftitem("hades_farming:bell_pepper", {
	description = S("Bell Pepper"),
	inventory_image = "hades_farming_bell_pepper.png",
	groups = { food = 2, eatable = 1 },
	on_use = minetest.item_eat(1),
})
minetest.register_craft({
	output = 'hades_farming:seed_bell_pepper',
	recipe = {{'hades_farming:bell_pepper'},}
})

-- SPICE
hades_farming.register_plant("hades_farming:spice", {
	description_seed = S("Spice Seed"),
	description_plant = S("Spice Shrub"),
	_tt_help = S("Grows on Wet Soil in light").."\n"..S("Season: Fall"),
	inventory_image = "hades_farming_spice_seed.png",
	steps = 3,
	meshoptions = 4,
	seasons = { hades_seasons.SEASON_FALL },
})
minetest.register_craftitem("hades_farming:spice", {
	description = S("Spice"),
	inventory_image = "hades_farming_spice.png",
})
minetest.register_craft({
	output = 'hades_farming:seed_spice',
	recipe = {{'hades_farming:spice'},}
})

