local S = minetest.get_translator("hades_carpets")
local F = minetest.formspec_escape

local colors = {
	"black",
	"blue",
	"brown",
	"cyan",
	"dark_green",
	"dark_grey",
	"green",
	"grey",
	"magenta",
	"orange",
	"pink",
	"red",
	"violet",
	"white",
	"yellow",
	"blackgold",
}

local machine_formspec =
	"formspec_version[6]"..
	"size[12.75,8]"..
	"bgcolor[#00000000;neither]"..
	"background9[0,0;10,6;gluncarp_background.png;true;6]"..
	"list[current_name;wool;4.075,1;1,1;]"..
	"image_button[5.8,1;1,1;gluncarp_mach1.png;carpet;]"..
	"list[current_name;res;7.6,1;1,1;]"..
	"label[4.075,0.5;"..F(S("Cloth:")).."]"..
	"label[5.8,0.5;"..F(S("Craft:")).."]"..
	"label[7.6,0.5;"..F(S("Output:")).."]"..
	"list[current_player;main;0.475,3;10,4;]"..
	"listring[current_player;main]"..
	"listring[current_name;wool]"..
	"listring[current_player;main]"..
	"listring[current_name;res]"

local desc = S("Carpet Workstation")
minetest.register_node("hades_carpets:machine", {
	description = desc,
	_tt_help = S("Turns cloth to carpets"),
	tiles = {
		"gluncarp_machine_top.png",
		"gluncarp_machine_bottom.png",
		"gluncarp_machine_side2.png",
		"gluncarp_machine_side1.png",
		"gluncarp_machine_back.png",
		"gluncarp_machine_front.png"
		},
	drawtype = "nodebox",
	paramtype = "light",
	paramtype2 = "facedir",
	is_ground_content = false,
	groups = {oddly_breakable_by_hand=2, choppy=3,owned=1},
	node_box = {
		type = "fixed",
		fixed = {
			{-0.5, -0.5, -0.125, 0.5, -0.375, 0.125}, 
			{-0.5, 0.375, 0.0625, 0.5, 0.4375, 0.125}, 
			{0.4375, -0.375, -0.125, 0.5, 0.375, -0.0625}, 
			{-0.5, -0.375, -0.125, -0.4375, 0.375, -0.0625}, 
			{0.21875, -0.375, -0.03125, 0.28125, 0.5, 0.03125}, 
			{-0.28125, -0.375, -0.03125, -0.21875, 0.5, 0.03125}, 
			{-0.03125, -0.4375, -0.03125, 0.03125, 0.5, 0.03125}, 
			{-0.3125, -0.3125, -0.03125, 0.3125, 0.3125, 0.03125}, 
			{-0.5, -0.5, -0.25, 0.5, -0.4375, 0.25}, 
			{0.4375, -0.4375, 0.0625, 0.5, 0.4375, 0.125}, 
			{-0.5, -0.4375, 0.0625, -0.4375, 0.4375, 0.125}, 
			{-0.5, 0.375, -0.125, 0.5, 0.4375, -0.0625}, 
			{-0.5, 0.375, -0.125, -0.375, 0.4375, 0.125}, 
			{0.375, 0.375, -0.125, 0.5, 0.4375, 0.125}, 
			{0.21875, 0.375, -0.0625, 0.28125, 0.4375, 0.0625}, 
			{-0.03125, 0.375, -0.0625, 0.03125, 0.4375, 0.0625}, 
			{-0.28125, 0.375, -0.0625, -0.21875, 0.4375, 0.0625},
		}
	},
	selection_box = {
		type = 'fixed',
		fixed = {
			{-0.5, -0.5, -0.25, 0.5, 0.5, 0.25} 
		}
	},
	sounds = hades_sounds.node_sound_wood_defaults(),

	on_rotate = "simple",

	can_dig = function(pos,player)
		local meta = minetest.get_meta(pos);
		local inv = meta:get_inventory()
		if not inv:is_empty("wool") then
			return false
		elseif not inv:is_empty("res") then
			return false
		end
		return true
	end,

	on_construct = function(pos)
		local meta = minetest.get_meta(pos)
		meta:set_string("formspec", machine_formspec)
		meta:set_string("infotext", S("Carpet Workstation"))
		local inv = meta:get_inventory()
		-- Input slot (called "wool" for historic reasons only)
		inv:set_size("wool", 1)
		inv:set_size("res", 1)
	end,

	on_receive_fields = function(pos, formname, fields, sender)
		local meta = minetest.get_meta(pos)
		local inv = meta:get_inventory()

		if not fields["carpet"] then
			return
		end

		if fields["carpet"] then
			if inv:is_empty("wool") then
				return
			end
		end

		local clothstack = inv:get_stack("wool", 1)
		local clothname = clothstack:get_name()
		local resstack = inv:get_stack("res", 1)
----------------------------------------------------------------------
--Register Items
----------------------------------------------------------------------
		local material
		-- the size of cloth items is measured in "eighths",
		-- i.e. in units of 1/8 that the node fills.
		-- a full block is 8 eighths, a half block (slab) is
		-- 4 eighths, etc.
		-- Bigger cloth blocks result in more carpets
		local eighths
		for col=1,#colors do
			local color = colors[col]
			if clothname == "hades_cloth:"..color then
				material = color
				eighths = 8
			elseif clothname == "hades_carpets:cloth_"..color then
				material = color
				eighths = 8
			elseif clothname == "hades_stairs:slab_"..color then
				material = color
				eighths = 4
			elseif clothname == "hades_stairs:stair_"..color then
				material = color
				eighths = 6
			elseif clothname == "hades_stairs:stair_in_"..color then
				material = color
				eighths = 7
			elseif clothname == "hades_stairs:stair_out_"..color then
				material = color
				eighths = 5
			elseif clothname == "hades_stairs:step_"..color then
				material = color
				eighths = 2
			elseif clothname == "hades_stairs:step_in_"..color then
				material = color
				eighths = 3
			elseif clothname == "hades_stairs:step_out_"..color then
				material = color
				eighths = 1
			end
		end
----------------------------------------------------------------------
		if material then
			local count = math.floor(eighths/2)
			if count <= 0 then
				return
			end
			local output_item = "hades_carpets:"..material
			if not inv:is_empty("res") then
				if resstack:get_name() ~= output_item then
					return
				elseif resstack:get_count() == resstack:get_stack_max() then
					return
				end
			end
			local success = false
			for i = 0, count-1 do
				local result = inv:add_item("res", output_item)
				if result ~= nil then
					success = true
				end
			end
			if success then
				clothstack:take_item()
				inv:set_stack("wool", 1, clothstack)
			end
		end            
	end,

	-- Slight offset to avoid z-fighting with item frame
	_hades_itemshow_offset = { x=-0.02, y=0, z=-0.02 },
})

--Craft

minetest.register_craft({
	output = 'hades_carpets:machine',
	recipe = {
		{'group:wood', 'group:stick', 'group:wood'},
		{'hades_farming:string', 'hades_farming:string', 'hades_farming:string'},
		{'group:wood', "group:stick", 'group:wood'},
	},
})

minetest.register_craft({
	type = "fuel",
	recipe = "hades_carpets:machine",
	burntime = 18,
})

minetest.register_lbm({
	name = "hades_carpets:update_meta_v_0_19_0",
	label = "Update carpet workstation meta (v0.19.0)",
	nodenames = { "hades_carpets:machine" },
	action = function(pos)
		local meta = minetest.get_meta(pos)
		meta:set_string("formspec", machine_formspec)
		meta:set_string("infotext", S("Carpet Workstation"))
		meta:set_string("owner", "")
	end,
})

minetest.register_alias("gluncarp:machine", "hades_carpets:machine")
