-- Register ABMs that very slowly create moss on nodes that support it.

-- General slow mossy growth for all mossifable nodes near water
minetest.register_abm({
	label = "Grow moss on mossifyable nodes near water",
	nodenames = {"group:mossifyable"},
	neighbors = {"air", "group:water"},
	interval = 600,
	chance = 65,
	action = function(pos, node)
		if minetest.find_node_near(pos, 2, {"group:water"}) == nil then
			return
		else
			local def = minetest.registered_nodes[node.name]
			if def and def._hades_mossy then
				minetest.swap_node(pos, {name=def._hades_mossy, param2=node.param2})
			end
		end
	end,
})

-- Extra moss growth ABM for mossifyable nodes that are closer to water
minetest.register_abm({
	label = "Grow moss on mossifyable nodes neighboring water",
	nodenames = {"group:mossifyable"},
	neighbors = {"group:water"},
	interval = 500,
	chance = 35,
	action = function(pos, node)
		local def = minetest.registered_nodes[node.name]
		if def and def._hades_mossy then
			minetest.swap_node(pos, {name=def._hades_mossy, param2=node.param2})
		end
	end,
})

