local S = minetest.get_translator("hades_trees")

local function generate_peartree(pos, check_light, override_trunk, override_leaves, replacement, override_fruit)
	if not override_trunk then
		override_trunk = "hades_trees:pear_tree"
	end
	if not override_leaves then
		override_leaves = "hades_trees:pear_leaves"
	end
	hades_trees.generate_tree_variant({
		{ hades_trees.generate_applelike_tree, { pos, check_light, override_trunk, override_leaves, replacement, {
			height_min = 4,
			height_max = 6,
			leaves_blob_min = vector.new(-2,-2,-2),
			leaves_blob_max = vector.new(2,3,2),
			random_leaves = 10,
		} } },
		{ hades_trees.generate_tree_schematic, { pos, minetest.get_modpath("hades_trees").."/schems/hades_trees_pear_tree_small.mts", check_light, "hades_trees:pear_tree", "hades_trees:pear_leaves", "hades_refruit:bud_pear", override_trunk, override_leaves, override_fruit } },
	})
end

hades_trees.register_trunk("pear_tree", {
	description = S("Pear Tree Trunk"),
	tiles = {"hades_trees_pear_tree_top.png", "hades_trees_pear_tree_top.png", "hades_trees_pear_tree.png"},
})
hades_trees.register_bark("pear_bark", {
	description = S("Pear Bark"),
	image = "hades_trees_pear_tree.png",
})

hades_trees.register_sapling("pear_sapling", {
	description = S("Pear Sapling"),
	image = "hades_trees_pear_sapling.png",
	selbox = {-0.3, -0.5, -0.3, 0.3, 0.35, 0.3},
	grow = generate_peartree,
	fruit = "hades_trees:pear",
	fruit_chance = 7,
})
hades_trees.register_seed("pear_seed", {
	description = S("Pear Seed"),
	image = "hades_trees_pear_seed.png",
	_hades_grows_to = "hades_trees:pear_sapling",
})

hades_trees.register_leaves("pear_leaves", {
	description = S("Pear Leaves"),
	image = "hades_trees_pear_leaves_colorable.png",
	ash_fertilizer = 3,
	trunk = "hades_trees:pear_tree",
	colorable = true,
	palette = "hades_trees_pear_leaves_palette.png",
	color_stereotype = "#77b247",
})
hades_trees.register_fruit("pear", {
	description = S("Pear"),
	drawtype = "plantlike",
	image = "hades_trees_pear.png",
	selbox = {-0.25, -0.375, -0.25, 0.25, 0.4375, 0.25},
	satiation = 2,
})

hades_trees.register_grow_abms({
	label = "Grow pear sapling and seed",
	sapling = "hades_trees:pear_sapling",
	seed = "hades_trees:pear_seed",
	interval = 10,
	chance = 50,
})


