local S = minetest.get_translator("hades_trees")

local function generate_coconutpalm(pos, check_light, override_trunk, override_leaves, replacements, override_fruit)
	local underground = table.copy(hades_trees.DEFAULT_UNDERGROUND)
	table.insert(underground, "hades_core:fertile_sand")

	hades_trees.generate_tree_variant({
		{ hades_trees.generate_tree_schematic, { pos, minetest.get_modpath("hades_trees").."/schems/hades_trees_coconut_tree.mts", check_light, "hades_trees:coconut_tree", "hades_trees:coconut_leaves", "hades_refruit:bud_coconut", override_trunk, override_leaves, override_fruit } },
		{ hades_trees.generate_tree_schematic, { pos, minetest.get_modpath("hades_trees").."/schems/hades_trees_coconut_tree_small.mts", check_light, "hades_trees:coconut_tree", "hades_trees:coconut_leaves", "hades_refruit:bud_coconut", override_trunk, override_leaves, override_fruit } },
	})
end

hades_trees.register_trunk("coconut_tree", {
	description = S("Coconut Palm Trunk"),
	tiles = {"hades_trees_coconut_tree_top.png", "hades_trees_coconut_tree_top.png", "hades_trees_coconut_tree.png"},
})
hades_trees.register_bark("coconut_bark", {
	description = S("Coconut Bark"),
	image = "hades_trees_coconut_tree.png",
})
hades_trees.register_leaves("coconut_leaves", {
	description = S("Coconut Leaves"),
	image = "hades_trees_coconut_leaves_colorable.png",
	colorable = true,
	palette = "hades_trees_coconut_leaves_palette.png",
	color_stereotype = "#7ac63b",
	leafdecay = 4,
	trunk = "hades_trees:coconut_tree",
})

hades_trees.register_sapling("coconut_sapling", {
	description = S("Coconut Palm Sapling"),
	image = "hades_trees_coconut_sapling.png",
	selbox = {-0.275, -0.5, -0.275, 0.275, 5/16, 0.275},
	grow = generate_coconutpalm,
	_growtype = "fertile_sand",
	fruit = "hades_trees:coconut",
	fruit_chance = 20,
})

-- The coconut seed is the inner part of a coconut.
-- Grows into coconut tree, can be used to craft other things.
hades_trees.register_seed("coconut_seed", {
	--~ A coconut WITHOUT its outer fruit shell. Can grow into a coconut tree. In English, this thing is confusingly often called just "coconut" as well.
	description = S("Coconut Seed"),
	_growtype = "fertile_sand",
	image = "hades_trees_coconut_seed.png",
	drawtype = "plantlike",
	tiles = {"hades_trees_coconut_seed_tile.png"},
	node_box = false,
	selection_box = {
		type = "fixed",
		fixed = { -4/16, -0.5, -4/16, 4/16, -2/16, 4/16 },
	},
	extra_groups = { choppy = 3 },
	sounds = hades_sounds.node_sound_wood_defaults(),
	_hades_grows_to = "hades_trees:coconut_sapling",
})

-- This is the raw coconut as is grows on the tree, so the outer shell is included.
-- Must be turned into coconut seed first to be useful.
hades_trees.register_fruit("coconut", {
	--~ Fruit of the coconut tree as it grows on the coconut tree, with its outer fruit shell intact
	description = S("Coconut"),
	drawtype = "plantlike",
	image = "hades_trees_coconut.png",
	selbox = {-4/16, -7/16, -4/16, 4/16, 7/16, 4/16},
	sounds = hades_sounds.node_sound_leaves_defaults(),
})

hades_trees.register_grow_abms({
	label = "Grow coconut sapling and seed",
	sapling = "hades_trees:coconut_sapling",
	seed = "hades_trees:coconut_seed",
	interval = 30,
	chance = 20,
	_growtype = "fertile_sand",
})
