hades_coords = {}

local transforms = {}

-- Set a coordinate offset to player.
-- Set offset to nil to reset.
hades_coords.set_pos_offset = function(player, offset)
	local pname = player:get_player_name()
	transforms[pname] = offset
end

-- Get current coordinate offset of player or
-- nil if no offset.
hades_coords.get_pos_offset = function(player)
	local pname = player:get_player_name()
	return transforms[pname]
end

-- Returns virtual position of player,
-- applying the coordinate offset
-- (if used)
hades_coords.get_pos = function(player)
	local pos = player:get_pos()
	local pname = player:get_player_name()
	if transforms[pname] then
		pos = vector.add(pos, transforms[pname])
	end
	return pos
end

minetest.register_on_leaveplayer(function(player)
	local pname = player:get_player_name()
	transforms[pname] = nil
end)
