-- Kaki Tree (formerly "Jungle Tree").
-- Based on the real-world tree known under
-- the scientific name "Diospyros kaki".
-- The string "jungle" is still used in the node IDs
-- for compatibility reasons.

local S = minetest.get_translator("hades_trees")

local function generate_kakitree(pos, check_light, override_trunk, override_leaves, replacement, override_fruit)
	if not override_trunk then
		override_trunk = "hades_trees:jungle_tree"
	end
	if not override_leaves then
		override_leaves = "hades_trees:jungle_leaves"
	end
	hades_trees.generate_tree_variant({
		{ hades_trees.generate_applelike_tree, {
			pos, check_light, override_trunk, override_leaves, replacement,
			{
				height_min = 6,
				height_max = 7,
				leaves_blob_min = vector.new(-3,-2,-3),
				leaves_blob_max = vector.new(3,4,3),
				random_leaves = 30,
			},
		} },
		{ hades_trees.generate_tree_schematic, { pos, minetest.get_modpath("hades_trees").."/schems/hades_trees_kaki_tree_small.mts", check_light, "hades_trees:jungle_tree", "hades_trees:jungle_leaves", "hades_refruit:bud_kaki", override_trunk, override_leaves, override_fruit } },
	})
end

hades_trees.register_trunk("jungle_tree", {
	--~ Trunk of the kaki tree (Diospyros kaki)
	description = S("Kaki Tree Trunk"),
	tiles = {"hades_trees_kaki_tree_top.png", "hades_trees_kaki_tree_top.png", "hades_trees_kaki_tree.png"},
})
hades_trees.register_bark("jungle_bark", {
	--~ Bark of the kaki tree (Diospyros kaki)
	description = S("Kaki Bark"),
	image = "hades_trees_kaki_tree.png",
})
hades_trees.register_leaves("jungle_leaves", {
	--~ Leaves of the kaki tree (Diospyros kaki)
	description = S("Kaki Leaves"),
	colorable = true,
	image = "hades_trees_kaki_leaves_colorable.png",
	palette = "hades_trees_kaki_leaves_palette.png",
	color_stereotype = "#83b555",
	ash_fertilizer = 3,
	drop_item = "hades_trees:jungle_seed",
	drop_rarity = 25,
	trunk = "hades_trees:jungle_tree",
})
hades_trees.register_sapling("jungle_sapling", {
	--~ Sapling of the kaki tree (Diospyros kaki)
	description = S("Kaki Tree Sapling"),
	image = "hades_trees_kaki_sapling.png",
	selbox = {-0.25, -0.5, -0.25, 0.25, 0.35, 0.25},
	grow = generate_kakitree,
	fruit = "hades_refruit:bud_kaki",
	fruit_chance = 38,
})
hades_trees.register_seed("jungle_seed", {
	--~ Seed of the kaki tree (Diospyros kaki)
	description = S("Kaki Seed"),
	image = "hades_trees_kaki_seed.png",
	_hades_grows_to = "hades_trees:jungle_sapling",
})
hades_trees.register_fruit("kaki", {
	--~ Fruit of the kaki tree (Diospyros kaki). Also known as "persimmon"
	description = S("Kaki Fruit"),
	drawtype = "plantlike",
	image = "hades_trees_kaki.png",
	selbox = {-3/16, -5/16, -3/16, 3/16, 5/16, 3/16},
	sounds = hades_sounds.node_sound_leaves_defaults(),
	satiation = 1,
})

hades_trees.register_grow_abms({
	label = "Grow kaki tree sapling and seed",
	sapling = "hades_trees:jungle_sapling",
	seed = "hades_trees:jungle_seed",
	interval = 10,
	chance = 50,
})

-- Aliases for the removed "Cultivated Jungle Tree"
minetest.register_alias("hades_trees:cultivated_jungle_leaves", "hades_trees:jungle_leaves")
minetest.register_alias("hades_trees:cultivated_jungle_sapling", "hades_trees:jungle_sapling")
minetest.register_alias("hades_trees:cultivated_jungle_seed", "hades_trees:jungle_seed")
