local S = minetest.get_translator("hades_flowerpots")

local flowers = {
	{"red", "hades_flowers:red_2", S("Flower Pot with Red Flower")},
	{"orange", "hades_flowers:orange_2", S("Flower Pot with Orange Flower")},
	{"blue", "hades_flowers:blue_2", S("Flower Pot with Blue Flower")},
	{"violet", "hades_flowers:violet_2", S("Flower Pot with Violet Flower")},
	{"yellow", "hades_flowers:yellow_2", S("Flower Pot with Yellow Flower")},
	{"white", "hades_flowers:white_2", S("Flower Pot with White Flower")},
	{"grey", "hades_flowers:grey_2", S("Flower Pot with Grey Flower")},
	{"pink", "hades_flowers:pink_2", S("Flower Pot with Pink Flower")},
	{"cyan", "hades_flowers:cyan_2", S("Flower Pot with Cyan Flower")},
	{"magenta", "hades_flowers:magenta_2", S("Flower Pot with Magenta Flower")},
	{"dead", "hades_flowers:dead", S("Flower Pot with Dead Flower")},

	{"branch_bush", "hades_bushes:branch_bush", S("Flower Pot with Branch Bush")},
	{"dead_garden_bush", "hades_bushes:dead", S("Flower Pot with Dead Garden Bush")},

	{"sapling", "hades_trees:sapling", S("Flower Pot with Apple Tree Sapling")},
	{"pear_sapling", "hades_trees:pear_sapling", S("Flower Pot with Pear Tree Sapling")},
	{"jungle_sapling", "hades_trees:jungle_sapling", S("Flower Pot with Kaki Tree Sapling")},
	{"olive_sapling", "hades_trees:olive_sapling", S("Flower Pot with Olive Tree Sapling")},
	{"pale_sapling", "hades_trees:pale_sapling", S("Flower Pot with Pale Tree Sapling")},
	{"birch_sapling", "hades_trees:birch_sapling", S("Flower Pot with Birch Tree Sapling")},
	{"orange_sapling", "hades_trees:orange_sapling", S("Flower Pot with Orange Tree Sapling")},
	{"banana_sapling", "hades_trees:banana_sapling", S("Flower Pot with Banana Tree Sapling")},
	{"cocoa_sapling", "hades_trees:cocoa_sapling", S("Flower Pot with Cocoa Tree Sapling")},
	{"coconut_sapling", "hades_trees:coconut_sapling", S("Flower Pot with Coconut Tree Sapling")},
	{"canvas_sapling", "hades_trees:canvas_sapling", S("Flower Pot with Canvas Tree Sapling")},
	{"dead_sapling", "hades_trees:dead_sapling", S("Flower Pot with Dead Sapling")},

	{"green_garden_bush", "hades_bushes:green_1", S("Flower Pot with Young Garden Bush"), true, "hades_bushes_young_overlay.png", "hades_bushes_young_colorable.png"},
	{"red_garden_bush", "hades_bushes:red_1", S("Flower Pot with Young Red-Flowering Garden Bush"), true, "hades_bushes_young_overlay.png", "hades_bushes_young_colorable.png"},
	{"blue_garden_bush", "hades_bushes:blue_1", S("Flower Pot with Young Blue-Flowering Garden Bush"), true, "hades_bushes_young_overlay.png", "hades_bushes_young_colorable.png"},
	{"yellow_garden_bush", "hades_bushes:yellow_1", S("Flower Pot with Young Yellow-Flowering Garden Bush"), true, "hades_bushes_young_overlay.png", "hades_bushes_young_colorable.png"},
	{"orange_garden_bush", "hades_bushes:orange_1", S("Flower Pot with Young Orange-Flowering Garden Bush"), true, "hades_bushes_young_overlay.png", "hades_bushes_young_colorable.png"},
	{"violet_garden_bush", "hades_bushes:violet_1", S("Flower Pot with Young Violet-Flowering Garden Bush"), true, "hades_bushes_young_overlay.png", "hades_bushes_young_colorable.png"},
	{"white_garden_bush", "hades_bushes:white_1", S("Flower Pot with Young White-Flowering Garden Bush"), true, "hades_bushes_young_overlay.png", "hades_bushes_young_colorable.png"},

	{"junglegrass", "hades_grass:junglegrass_1", S("Flower Pot with Young Tropical Grass"), true},

	{"grass", "hades_grass:grass_1", S("Flower Pot with Grass Clump"), true, "hades_flowerpots_grass_plant_colorable.png"},
	{"dead_grass", "hades_grass:dead_grass_1", S("Flower Pot with Dead Grass Clump"), false, "hades_flowerpots_dead_grass_plant_colorable.png"},
	{"sugarcane", "hades_core:sugarcane", S("Flower Pot with Sugarcane"), true, "hades_flowerpots_sugarcane.png"},
	{"sugarcane_rotten", "hades_core:sugarcane_rotten", S("Flower Pot with Rotten Sugarcane"), true, "hades_flowerpots_sugarcane_rotten.png"},
}

local cuboids = {
	{"cactus", "hades_core:cactus", S("Flower Pot with Cactus")},
	{"cactus_rotten", "hades_core:cactus_rotten", S("Flower Pot with Rotten Cactus")},

	{"leaves", "hades_trees:leaves", S("Flower Pot with Apple Leaves"), true},
	{"pear_leaves", "hades_trees:pear_leaves", S("Flower Pot with Pear Leaves"), true},
	{"jungle_leaves", "hades_trees:jungle_leaves", S("Flower Pot with Kaki Leaves"), true},
	{"cocoa_leaves", "hades_trees:cocoa_leaves", S("Flower Pot with Cocoa Leaves"), true},
	{"coconut_leaves", "hades_trees:coconut_leaves", S("Flower Pot with Coconut Leaves"), true},
	{"olive_leaves", "hades_trees:olive_leaves", S("Flower Pot with Olive Leaves"), true},
	{"birch_leaves", "hades_trees:birch_leaves", S("Flower Pot with Birch Leaves"), true},
	{"pale_leaves", "hades_trees:pale_leaves", S("Flower Pot with Pale Leaves"), true},
	{"orange_leaves", "hades_trees:orange_leaves", S("Flower Pot with Orange Leaves"), true},
	{"banana_leaves", "hades_trees:banana_leaves", S("Flower Pot with Banana Leaves"), true},
	{"canvas_leaves", "hades_trees:canvas_leaves", S("Flower Pot with Canvas Leaves"), true},
	{"burned_branches", "hades_trees:burned_branches", S("Flower Pot with Burned Branches"), true},
}

minetest.register_node("hades_flowerpots:flower_pot", {
	description = S("Flower Pot"),
	_tt_help = S("Can hold a flower or other small plant"),
	drawtype = "mesh",
	mesh = "hades_flowerpots_flowerpot.obj",
	tiles = {
		"hades_flowerpots_flowerpot.png",
	},
	use_texture_alpha = "clip",
	paramtype = "light",
	is_ground_content = false,
	floodable = true,
	on_flood = function(pos, oldnode, newnode)
		-- Node is destroyed if flooded by lava.
		-- If flooded by anything else, drops as item.
		if minetest.get_item_group(newnode.name, "lava") == 0 then
			minetest.add_item(pos, oldnode.name)
		end
	end,
	selection_box = {
		type = "fixed",
		fixed = {-0.2, -0.5, -0.2, 0.2, -0.1, 0.2}
	},
	collision_box = {
		type = "fixed",
		fixed = {-0.2, -0.5, -0.2, 0.2, -0.1, 0.2}
	},
	groups = {flower_pot = 1, cracky = 3, oddly_breakable_by_hand = 1, attached_node=1},
	sounds = hades_sounds.node_sound_stone_defaults(),
	on_rightclick = function(pos, node, clicker, itemstack)
		local item = clicker:get_wielded_item():get_name()
		local name = clicker:get_player_name()
		if minetest.is_protected(pos, name) and not minetest.check_player_privs(name, "protection_bypass") then
			minetest.record_protection_violation(pos, name)
			return
		end
		local newnodename, newparam2
		for _, row in ipairs(flowers) do
			local flower = row[1]
			local flower_node = row[2]
			if item == flower_node then
				local fdef = minetest.registered_nodes[flower_node]
				if fdef and fdef.sounds and fdef.sounds.place then
					minetest.sound_play(fdef.sounds.place, {pos=pos}, true)
				end
				newnodename = "hades_flowerpots:flower_pot_"..flower
				break
			end
		end
		for _, row in ipairs(cuboids) do
			local cuboid = row[1]
			local cuboid_node = row[2]
			if item == cuboid_node then
				local cdef = minetest.registered_nodes[cuboid_node]
				if cdef and cdef.sounds and cdef.sounds.place then
					minetest.sound_play(cdef.sounds.place, {pos=pos}, true)
				end
				newnodename = "hades_flowerpots:flower_pot_"..cuboid
				break
			end
		end
		if newnodename then
			if minetest.get_item_group(newnodename, "flower_pot_seasonal") ~= 0 then
				newparam2 = hades_seasons.get_seasonal_palette_color_param2()
			end
			minetest.set_node(pos, {name=newnodename, param2=newparam2})
			if not minetest.is_creative_enabled(name) then
				itemstack:take_item()
			end
		end
	end,
})

minetest.register_craft({
	output = 'hades_flowerpots:flower_pot',
	recipe = {
		{'hades_core:clay_brick', '', 'hades_core:clay_brick'},
		{'', 'hades_core:clay_brick', ''},
	}
})

for _, row in ipairs(flowers) do
local flower = row[1]
local flower_node = row[2]
local desc = row[3]
local def = minetest.registered_nodes[flower_node]
local seasonal = row[4] == true
local texture = row[5] or def["tiles"][1]
local overlay_texture = row[6]
if def["overlay_tiles"] then
	overlay_texture = row[6] or def["overlay_tiles"][1]
end
local palette, paramtype2
local tiles, overlay_tiles
if def.palette then
	palette = def.palette
	paramtype2 = "color"
	if overlay_texture then
		tiles = {
			{ name = "[combine:32x32:0,0=hades_flowerpots_flowerpot.png:0,0="..texture, color = "white" },
		}
		overlay_tiles = {
			"[combine:32x32:0,0="..overlay_texture,
		}
	else
		tiles = {
			{ name = "[combine:32x32:0,0=hades_flowerpots_flowerpot.png", color = "white" },
		}
		overlay_tiles = {
			"[combine:32x32:0,0="..texture,
		}
	end
else
	tiles = {
		"[combine:32x32:0,0=hades_flowerpots_flowerpot.png:0,0="..texture,
	}
end

local g_seasonal
if seasonal then
	g_seasonal = 1
end
minetest.register_node("hades_flowerpots:flower_pot_"..flower, {
	description = desc,
	drawtype = "mesh",
	mesh = "hades_flowerpots_flowerpot.obj",
	tiles = tiles,
	overlay_tiles = overlay_tiles,
	palette = palette,
	paramtype2 = paramtype2,
	color = def.color,
	use_texture_alpha = "clip",
	paramtype = "light",
	is_ground_content = false,
	floodable = true,
	on_flood = function(pos, oldnode, newnode)
		-- Node is destroyed if flooded by lava.
		-- If flooded by anything else, drops as flower pot and flower (2 items)
		if minetest.get_item_group(newnode.name, "lava") == 0 then
			minetest.add_item(pos, "hades_flowerpots:flower_pot")
			minetest.add_item(pos, flower_node)
		end
	end,
	selection_box = {
		type = "fixed",
		fixed = {-0.2, -0.5, -0.2, 0.2, -0.1, 0.2},
	},
	collision_box = {
		type = "fixed",
		fixed = {-0.2, -0.5, -0.2, 0.2, -0.1, 0.2},
	},
	groups = {flower_pot = 2, flower_pot_seasonal = g_seasonal, cracky = 3, oddly_breakable_by_hand = 1, not_in_creative_inventory=1, attached_node=1},
	sounds = hades_sounds.node_sound_stone_defaults(),
	on_rightclick = function(pos, item, clicker)
		local name = clicker:get_player_name()
		if minetest.is_protected(pos, name) and not minetest.check_player_privs(name, "protection_bypass") then
			minetest.record_protection_violation(pos, name)
			return
		end
		if not minetest.is_creative_enabled(name) then
			minetest.add_item({x=pos.x, y=pos.y+0.5, z=pos.z}, flower_node)
		end
		local fdef = minetest.registered_nodes[flower_node]
		if fdef and fdef.sounds and fdef.sounds.dug then
			minetest.sound_play(fdef.sounds.dug, {pos=pos}, true)
		end
		minetest.set_node(pos, {name="hades_flowerpots:flower_pot"})
	end,
	drop = {
	max_items = 2,items = {{items = {"hades_flowerpots:flower_pot", flower_node},rarity = 1,},},
	},
})
end

for _, row in ipairs(cuboids) do
local flower = row[1]
local flower_node = row[2]
local desc = row[3]
local seasonal = row[4] == true
local palette, paramtype2
local tiles, overlay_tiles
local def = minetest.registered_nodes[flower_node]
local texture = row[5] or def["tiles"][1]
if def.palette then
	palette = def.palette
	paramtype2 = "color"
	tiles = {
		-- flower pot + inner cuboid textures
		{ name = '[combine:32x32:0,0=hades_flowerpots_cuboid_base.png:0,0=(hades_flowerpots_'..flower..'.png\\^[mask\\:hades_flowerpots_mask_cuboid_inner.png)', color = "white" }
	}
	overlay_tiles = {
		-- outer cuboid textures
		{ name = '[combine:32x32:0,0=(hades_flowerpots_'..flower..'.png\\^[mask\\:hades_flowerpots_mask_cuboid_outer.png)' },
	}
else
	tiles = {'[combine:32x32:0,0=hades_flowerpots_cuboid_base.png:0,0=hades_flowerpots_'..flower..'.png'}
end
local g_seasonal
if seasonal then
	g_seasonal = 1
end
minetest.register_node("hades_flowerpots:flower_pot_"..flower, {
	description = desc,
	drawtype = "mesh",
	mesh = "hades_flowerpots_flowerpot_with_cuboid.obj",
	tiles = tiles,
	overlay_tiles = overlay_tiles,
	use_texture_alpha = "clip",
	paramtype = "light",
	paramtype2 = paramtype2,
	palette = palette,
	color = def.color,
	is_ground_content = false,
	selection_box = {
		type = "fixed",
		fixed = {-0.2, -0.5, -0.2, 0.2, -0.1, 0.2}
	},
	collision_box = {
		type = "fixed",
		fixed = {-0.2, -0.5, -0.2, 0.2, -0.1, 0.2}
	},
	groups = {flower_pot = 2, cracky = 3, oddly_breakable_by_hand = 1, not_in_creative_inventory=1, attached_node=1, flower_pot_seasonal = g_seasonal},
	sounds = hades_sounds.node_sound_stone_defaults(),
	on_rightclick = function(pos, item, clicker)
		local name = clicker:get_player_name()
		if minetest.is_protected(pos, name) and not minetest.check_player_privs(name, "protection_bypass") then
			minetest.record_protection_violation(pos, name)
			return
		end
		if not minetest.is_creative_enabled(name) then
			minetest.add_item({x=pos.x, y=pos.y+0.5, z=pos.z}, flower_node)
		end
		local fdef = minetest.registered_nodes[flower_node]
		if fdef and fdef.sounds and fdef.sounds.dug then
			minetest.sound_play(fdef.sounds.dug, {pos=pos}, true)
		end
		minetest.set_node(pos, {name="hades_flowerpots:flower_pot"})
	end,
	drop = {
	max_items = 2,items = {{items = {"hades_flowerpots:flower_pot", flower_node},rarity = 1,},},
	},
})
end

minetest.register_abm({
	label = "Update seasonal plant in flower pot",
	nodenames = {"group:flower_pot_seasonal"},
	interval = 5,
	chance = 20,
	action = function(pos, node)
		local season = hades_seasons.get_season()
		if not season then
			return
		end
		local old_param2 = node.param2
		local new_param2 = hades_seasons.get_seasonal_palette_color_param2(old_param2)
		if new_param2 ~= old_param2 then
			minetest.set_node(pos, {name = node.name, param2 = new_param2})
		end
	end
})

-- Legacy aliases for the removed "Cultivated Jungle Tree"
minetest.register_alias("hades_flowerpots:flower_pot_cultivated_jungle_sapling", "hades_flowerpots:flower_pot_jungle_sapling")
minetest.register_alias("hades_flowerpots:flower_pot_cultivated_jungle_leaves", "hades_flowerpots:flower_pot_jungle_leaves")
