local S = minetest.get_translator("lzr_core")

minetest.register_node("lzr_core:stone", {
	description = S("Stone"),
	tiles = {"default_stone.png"},
	groups = {cracky = 3, stone = 1},
	sounds = lzr_sounds.node_sound_stone_defaults(),
})


minetest.register_node("lzr_core:tree", {
	description = S("Tree Trunk"),
	tiles = {"default_tree_top.png", "default_tree_top.png", "default_tree.png"},
	paramtype2 = "facedir",
	is_ground_content = false,
	groups = {tree = 1, choppy = 2, oddly_breakable_by_hand = 1},
	sounds = lzr_sounds.node_sound_wood_defaults(),

	on_place = minetest.rotate_node
})

minetest.register_node("lzr_core:wood", {
	description = S("Wood Planks"),
	tiles = {"default_wood.png"},
	is_ground_content = false,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, wood = 1},
	sounds = lzr_sounds.node_sound_wood_defaults(),
})

minetest.register_node("lzr_core:water_source", {
	description = S("Water Source"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "default_water_source_animated.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "default_water_source_animated.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	pointable = true,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	liquidtype = "source",
	liquid_alternative_flowing = "lzr_core:water_source",
	liquid_alternative_source = "lzr_core:water_source",
	liquid_viscosity = 1,
	liquid_range = 0,
	post_effect_color = {a = 192, r = 30, g = 60, b = 90},
	groups = {water = 3, liquid = 3, cools_lava = 1},
})

