local S = minetest.get_translator("lzr_laser")

-- Distance from center to side of the laser beam square. Not really the radius, but it sounds cooler. :P
local LASER_RADIUS = -1/16

-- Returns a nodebox for the given dirs table
local function dirs_to_nodebox(dirs)
	local boxes = {}
	local x = dirs[1] == 1 or dirs[4] == 1
	local y = dirs[2] == 1 or dirs[5] == 1
	local z = dirs[3] == 1 or dirs[6] == 1

	-- True if 2 or more axes are used
	local multidir = (x and y) or (x and z) or (y and z)

	-- Center block
	if multidir and (x or y or z) then
		table.insert(boxes, { -LASER_RADIUS, -LASER_RADIUS, -LASER_RADIUS, LASER_RADIUS, LASER_RADIUS, LASER_RADIUS })
	end

	-- Axes (X, Y, Z)
	if x then
		if not multidir then
			table.insert(boxes, { -0.5, -LASER_RADIUS, -LASER_RADIUS, 0.5, LASER_RADIUS, LASER_RADIUS })
		else
			table.insert(boxes, { -0.5, -LASER_RADIUS, -LASER_RADIUS, LASER_RADIUS, LASER_RADIUS, LASER_RADIUS })
			table.insert(boxes, { -LASER_RADIUS, -LASER_RADIUS, -LASER_RADIUS, 0.5, LASER_RADIUS, LASER_RADIUS })
		end
	end
	if y then
		if not multidir then
			table.insert(boxes, { -LASER_RADIUS, -0.5, -LASER_RADIUS, LASER_RADIUS, 0.5, LASER_RADIUS })
		else
			table.insert(boxes, { -LASER_RADIUS, -0.5, -LASER_RADIUS, LASER_RADIUS, LASER_RADIUS, LASER_RADIUS })
			table.insert(boxes, { -LASER_RADIUS, -LASER_RADIUS, -LASER_RADIUS, LASER_RADIUS, 0.5, LASER_RADIUS })
		end
	end
	if z then
		if not multidir then
			table.insert(boxes, { -LASER_RADIUS, -LASER_RADIUS, -0.5, LASER_RADIUS, LASER_RADIUS, 0.5 })
		else
			table.insert(boxes, { -LASER_RADIUS, -LASER_RADIUS, -0.5, LASER_RADIUS, LASER_RADIUS, LASER_RADIUS })
			table.insert(boxes, { -LASER_RADIUS, -LASER_RADIUS, -LASER_RADIUS, LASER_RADIUS, LASER_RADIUS, 0.5 })
		end
	end
	return boxes
end

-- Register laser nodes
-- 64 nodes because 2^6 (6 directions with on/off state)
for i=1, 64 do
	local dirstring = lzr_laser.dec2bin(i, 6)
	local dirs = lzr_laser.dirstring_to_dirs(dirstring)
	minetest.register_node("lzr_laser:laser_"..dirstring, {
		description = S("Laser (@1)", dirstring),
		paramtype = "light",
		drawtype = "nodebox",
		sunlight_propagates = true,
		walkable = false,
		use_texture_alpha = "blend",
		tiles = { "lzr_laser_laser.png", },
		pointable = false,
		buildable_to = true,
		node_box = {
			type = "fixed",
			fixed = dirs_to_nodebox(dirs),
		},
		groups = { laser = i, not_in_creative_inventory = 1 },
		drop = "",
	})
end
