local S = minetest.get_translator("lzr_levels")

lzr_levels = {}

local ROOM_NODE = "lzr_core:wood"
local WINDOW_NODE = "xdecor:woodframed_glass"
local WINDOW_HEIGHT = 3
local WINDOW_DIST = 3

local build_room = function(param)
	local pos = param.pos
	local psize = param.size
	local posses_border = {}
	local posses_window = {}
	local posses_air = {}
	local size = vector.add(psize, {x=1,y=1,z=1})
	for x=0,size.x do
	for z=0,size.z do
	for y=0,size.y do
		local offset = {x=x-1, y=y-1, z=z-1}
		if (x >= 1 and x < size.x) and
		(y >= 1 and y < size.y) and
		(z >= 1 and z < size.z) then
			table.insert(posses_air, vector.add(pos, offset))
		elseif y == WINDOW_HEIGHT and ((x >= 1 and x < size.x and x % WINDOW_DIST == 0) or (z >= 1 and z < size.z and z % WINDOW_DIST == 0)) then
			table.insert(posses_window, vector.add(pos, offset))
		else
			table.insert(posses_border, vector.add(pos, offset))
		end
	end
	end
	end
	minetest.bulk_set_node(posses_border, {name=ROOM_NODE})
	minetest.bulk_set_node(posses_window, {name=WINDOW_NODE})
	minetest.bulk_set_node(posses_air, {name="air"})
end

local emerge_callback = function(blockpos, action, calls_remaining, param)
	minetest.log("verbose", "[lzr_levels] emerge_callback() ...")
	if action == minetest.EMERGE_ERRORED then
		minetest.log("error", "[lzr_levels] Room emerging error.")
	elseif action == minetest.EMERGE_CANCELLED then
		minetest.log("error", "[lzr_levels] Room emerging cancelled.")
	elseif calls_remaining == 0 and (action == minetest.EMERGE_GENERATED or action == minetest.EMERGE_FROM_DISK or action == minetest.EMERGE_FROM_MEMORY) then
		build_room(param)
		lzr_levels.build_level(param.level)
		minetest.log("action", "[lzr_levels] Room emerged and built.")
	end
end

local prepare_room = function(pos, size, level)
	minetest.emerge_area(pos, vector.add(pos, size), emerge_callback, {pos=pos, size=size, level=level})
end

function lzr_levels.build_room(pos, size, level)
	prepare_room(pos, size, level)
end

function lzr_levels.prepare_and_build_level(level)
	lzr_levels.build_room(lzr_globals.LEVEL_POS, {x=10, y=6, z=10}, level)
end

function lzr_levels.build_level(level)
	minetest.place_schematic(lzr_globals.LEVEL_POS, minetest.get_modpath("lzr_levels").."/schematics/lzr_levels_level_"..tonumber(level)..".mts", "0", {}, true, "")
end


local current_level = 1
-- Startup
minetest.register_on_joinplayer(function(player)
	local inv = player:get_inventory()
	for i=1,inv:get_size("main") do
		inv:set_stack("main", i, "")
	end
	inv:add_item("main", "screwdriver:screwdriver")
	lzr_levels.prepare_and_build_level(1)
	player:set_pos({x=5,y=2,z=5})
end)

function lzr_levels.next_level()
	local player = minetest.get_player_by_name("singleplayer")
	current_level = current_level + 1
	if current_level > 10 then
		minetest.chat_send_player("singleplayer", S("Yarrrr! You finished the last level!"))
	else
		minetest.chat_send_player("singleplayer", S("Yarr! Level @1 completed!", current_level - 1))
		player:set_pos({x=5,y=2,z=5})
		lzr_levels.prepare_and_build_level(current_level)

		local inv = player:get_inventory()
		for i=1,inv:get_size("main") do
			inv:set_stack("main", i, "")
		end
		inv:add_item("main", "screwdriver:screwdriver")
	end
end
