-- Create ocean

local WATER_LEVEL = 0

minetest.register_on_generated(function(minp, maxp)
	if maxp.y >= WATER_LEVEL and minp.y <= WATER_LEVEL then
		local vm, emin, emax = minetest.get_mapgen_object("voxelmanip")
		local data = vm:get_data()
		local area = VoxelArea:new({MinEdge=emin, MaxEdge=emax})
		local c_water = minetest.get_content_id("lzr_core:water_source")

		for x = minp.x, maxp.x do
			for z = minp.z, maxp.z do
				for y = minp.y, math.min(WATER_LEVEL, maxp.y) do
					local p_pos = area:index(x, y, z)
					data[p_pos] = c_water
				end
			end
		end

		vm:set_data(data)
		vm:update_liquids()
		vm:calc_lighting()
		vm:write_to_map()
	end
end)


