local S = minetest.get_translator("lzr_laser")

minetest.register_tool("lzr_laser:emit_toggler", {
	description = S("Emitter Toggler"),
	inventory_image = "lzr_laser_emitter_on.png",
	groups = { cheat_item = 1 },
	on_use = function(itemstack, user, pointed_thing)
		if pointed_thing.type ~= "node" then
			return itemstack
		end
		local pos = pointed_thing.under
		local node = minetest.get_node(pos)
		local is_emit = minetest.get_item_group(node.name, "emitter") > 0
		if not is_emit then
			return itemstack
		end
		local def = minetest.registered_nodes[node.name]
		-- Deactivate emitter
		if def._lzr_inactive then
			minetest.swap_node(pos, {name=def._lzr_inactive, param2=node.param2})
			lzr_laser.full_laser_update(lzr_globals.PLAYFIELD_START, lzr_globals.PLAYFIELD_END)
		-- Activate emitter
		elseif def._lzr_active then
			minetest.swap_node(pos, {name=def._lzr_active, param2=node.param2})
			lzr_laser.full_laser_update(lzr_globals.PLAYFIELD_START, lzr_globals.PLAYFIELD_END)
		end
		return itemstack
	end,
})

