# How to use the Level Editor
The game has a level editor to create your own levels.

To start the editor, punch the book labelled “Level editor”
in the main menu ship or enter the “`/editor`” chat command.
To exit the editor, use the “Exit” button in the inventory
or enter the “`/editor exit`” chat command.

If you enter the editor, you start with an empty room,
a larger inventory, and a couple of basic items.
In the inventory menu, you can access all items with the
“Get items” button.

## Creating a level

When you start to create a new level, you should first
choose a size and the level boundaries (the blocks that surround
the level on the floor, walls and ceiling). You can do this
in the “Level settings” in your inventory menu.

The level boundaries need to be specified as itemstrings like
`lzr_core:wood`. Invalid values will be automatically replaced
by a default. The special “window node” will appear at the
wall 2 blocks above the floor, each spaced 2 blocks apart.

**WARNING**: Reducing the level size will remove all nodes
that would no longer fit into the level!

When you look around in the world, you will see 8 white crosses.
These are the 8 corners of the level. Only the blocks enclosed
by these symbols will be saved. Every level will be automatically
surrounded by the boundary blocks (ceiling, wall, floor) which
are *not* part of the `.mts` level file.

You can now proceed to build the level.

Use the Ultra Pickaxe to remove blocks, and the Ultra Bucket to
remove liquids.

### Level rules

To work properly, every level needs to:

* Be solvable (duh!)
* Have at least one treasure chest (locked or unlocked)
* Exactly ONE teleporter in "off" state (`lzr_teleporter:teleporter_off`)
  (The player starts here, it also acts as a simple game menu when punched)

## Saving and loading

When you're happy with the level, use the “Save level” button in your
inventory.

Your level will be saved in the **world directory** in two files:

* The level schematic goes to `levels/<level name>.mts`
* The level settings go to `levels/<level name>.csv`

The `.mts` file is a Minetest schematic which is where all the blocks go.
It may also be edited by other tools that support this file format.

**WARNING**: If you delete the world, you will also lose all custom levels
stored in the world!

Loading the level works in a similar fashion with “Load level”.

You may also use the commands `editor_save` and `editor_load` instead.

### Auto-save

To prevent loss of work, the editor will automatically save the level
into `_AUTOSAVE_` at the following events:

* Leave the game
* Leave the editor
* Change level size or boundary nodes

`_AUTOSAVE_` will be overwritten whenever one of these events happen,
so make sure to save your work into other files.

## Testing the level

All levels created in the editor (except `_AUTOSAVE_`) will be available
to play in the main menu ship as a custom level.
You can start playtesting the level here.


## Adding the level to the game

If you think you made a nice level, send it to Wuzzy per e-mail at
Wuzzy@disroot.org. This game desperately needs more levels, so submissions
are appreciated. :D


### Technical steps

To add a new level to the main level set, the following technical
steps are performed:

First, copy the level `.mts` file to `mods/lzr_levels/schematics`.

Then open the `.csv` file from the `levels` folder in the world directory
and copy the single line of text. Add this line to
`mods/lzr_levels/data/level_data.csv`.

Now just restart the game and the level should appear!

### Syntax of `level_data.csv`

Although not strictly necessary to understand this, here is the syntax
of `level_data.csv`. This is a comma-separated values
file (compliant with RFC 4180) where each row represents a level.

Each row contains multiple values, in this order:

* `<file name>`: File name of the level `.mts` file
* `<level name>`: Name of the level as shown to the player, in English
* `<border list>`: List of border blocks, see below
* `<ambience>`: Ambient sounds. Either `ocean`, `temple` or `none`.
* `<sky>`: Sky ID. See the mod `lzr_sky` for available skies. (optional)
* `<npc_texts>`: This is the text that will show when the player interacts with the information block. (optional)
* `<weather>`: Weather ID. See the mod `lzr_weather` for available weathers. (optional)

Border list is a list of nodes used for the level border.
It contains 1-4 node names, separated by `|`. The border nodes are, in this order:

* Wall|Window|Floor|Ceiling

Wall is mandatory, the rest is optional. If window, floor or ceiling are missing,
they will the same as wall.

Note: The same syntax is also used for the `.csv` files created by the level
editor, the only difference is that these files only contain 1 row,
namely for the level they apply to.
