local S = minetest.get_translator("lzr_parrot_npc")
local FS = function(...) return minetest.formspec_escape(S(...)) end
local NS = function(s) return s end

local F = minetest.formspec_escape

lzr_parrot_npc = {}

-- TODO: These strings are to be used when the parrot model arrives
local SPEAKER_NAME = NS("Goldie the Parrot")
local SPEAKER_NAME_SHORT = NS("Goldie")
local SAYS = NS("@1 says:")

-- TODO: This name shall be removed when the parrot model arrives
local SPEAKER_NAME_INFOBLOCK = S("Information")

local function make_call(to_player)
	-- TODO: Play sound when we have a parrot again
end

lzr_parrot_npc.speak = function(player, message)
	local form = "formspec_version[6]size[10,5.5]"..
		"box[0,0;10,0.8;#0000004f]"..
		"label[0.4,0.4;"..F(SPEAKER_NAME_INFOBLOCK).."]"..
		"box[0.5,1;2.0,3;#0000002f]"..
		"image[0.75,1;1.5,3;lzr_parrot_npc_goldie_portrait.png]"..
		"box[3,1;6.5,3;#ffffff1f]"..
		"textarea[3,1;6.5,3;;;"..F(message).."]"..
		"button_exit[3.5,4.4;3,0.8;ok;"..FS("OK").."]"
	minetest.show_formspec(player:get_player_name(), "lzr_parrot_npc:speech", form)

	make_call(player)
end

-- Make parrot face player
local face_player = function(parrot, player)
	-- TODO: Face placer when we have an actual parrot
end

-- Either show the current level hint for Goldie,
-- or play the parrot sound if no NPC text.
local react = function(parrot, player)
	if player and player:is_player() then
		local speeches = lzr_levels.get_npc_texts()
		if speeches and speeches.goldie and speeches.goldie ~= "" then
			lzr_parrot_npc.speak(player, speeches.goldie)
		else
			make_call(player)
		end
		face_player(parrot, player)
	end
end

-- TODO: The parrot NPC is currently replaced
-- by a rotating information block
minetest.register_entity("lzr_parrot_npc:parrot", {
	initial_properties = {
		visual = "cube",
		-- TODO: Create a parrot model
		visual_size = { x=0.5, y=0.5, z=0.5 },
		textures = {
			"lzr_parrot_npc_goldie.png",
			"lzr_parrot_npc_goldie.png",
			"lzr_parrot_npc_goldie.png",
			"lzr_parrot_npc_goldie.png",
			"lzr_parrot_npc_goldie.png",
			"lzr_parrot_npc_goldie.png",
		},
		static_save = false,
		physical = false,
		collide_with_objects = false,
		selectionbox = {
			-0.25, -0.25, -0.25, 0.25, 0.25, 0.25, rotate = true,
		},
		-- TODO: Remove for actual parrot
		automatic_rotate = 1,
	},
	-- TODO: Add random parrot animation and looking
	-- (on_step, on_activate)
	on_rightclick = function(self, clicker)
		react(self, clicker)
	end,
	on_punch = function(self, puncher)
		react(self, puncher)
	end,
})

minetest.register_node("lzr_parrot_npc:stand", {
	description = S("Parrot Stand"),
	drawtype = "nodebox",
	paramtype = "light",
	paramtype2 = "4dir",
	sunlight_propagates = true,
	is_ground_content = false,
	node_box = {
		type = "fixed",
		fixed = {
			{ -0.5, -0.5, -0.5, 0.5, 1/16, 0.5 }, -- base (slab-like)
			{ -1/16, 1/16, -1/16, 1/16, 7/16, 1/16 }, -- vertical stick
			{ -6/16, 7/16, -1/16, 6/16, 0.5, 1/16 }, -- parrot stick
		},
	},
	tiles = { { name = "default_wood.png", align_style = "world" } },
	groups = { breakable = 1 },
	sounds = lzr_sounds.node_sound_wood_defaults(),
})

-- TODO: Use this description when we have a real parrot
local real_description = NS("Parrot Spawner")

minetest.register_node("lzr_parrot_npc:parrot_spawner", {
	-- TODO: Switch description when we have a real parrot
	description = S("Information Block Spawner"),
	tiles = {
		"lzr_parrot_npc_goldie_spawner_top.png",
		"lzr_parrot_npc_goldie_spawner_top.png^[transformR180",
		"lzr_parrot_npc_goldie_spawner_side.png",
		"lzr_parrot_npc_goldie_spawner_side.png",
		"lzr_parrot_npc_goldie_spawner_side.png",
		"lzr_parrot_npc_goldie_spawner.png",
	},
	paramtype2 = "degrotate",
	drawtype = "mesh",
	mesh = "lzr_parrot_npc_cube.obj",
	visual_scale = 0.8,
	wield_scale = { x=0.8, y=0.8, z=0.8 },
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	groups = { breakable = 1, rotatable = 3 },
	use_texture_alpha = "clip",
	sounds = {
		_rotate = "",
	},
})
