local S = minetest.get_translator("lzr_gui")
local F = minetest.formspec_escape

lzr_gui = {}

local hud_ids = {}

lzr_gui.hide_treasure_status = function(player)
	local name = player:get_player_name()
	if hud_ids[name].treasures_img then
		player:hud_remove(hud_ids[name].treasures_img)
		hud_ids[name].treasures_img = nil
	end
	if hud_ids[name].treasures_cnt then
		player:hud_remove(hud_ids[name].treasures_cnt)
		hud_ids[name].treasures_cnt = nil
	end
end

lzr_gui.update_treasure_status = function(player, treasures, total_treasures)
	local name = player:get_player_name()
	if not hud_ids[name].treasures_img then
		local id = player:hud_add({
			hud_elem_type = "image",
			position = { x = 1, y = 1 },
			name = "treasure_img",
			text = "lzr_treasure_gold_block.png",
			alignment = { x = -1, y = -1 },
			offset = { x = -10, y = -20 },
			scale = { x = 3, y = 3 },
			size = { x = 3, y = 3 },
			z_index = 0,
		})
		hud_ids[name].treasures_img = id
	end
	local treasure_text = S("@1 / @2", treasures, total_treasures)
	local color = 0xFFFFFFFF
	if treasures >= total_treasures then
		color = 0xFF00FF00
	end
	if not hud_ids[name].treasures_cnt then
		local id = player:hud_add({
			hud_elem_type = "text",
			position = { x = 1, y = 1 },
			name = "treasure_cnt",
			text = treasure_text,
			number = color,
			alignment = { x = -1, y = -1 },
			offset = { x = -70, y = -20 },
			scale = { x = 100, y = 100 },
			size = { x = 3, y = 3 },
			z_index = 0,
		})
		hud_ids[name].treasures_cnt = id
	else
		player:hud_change(hud_ids[name].treasures_cnt, "text", treasure_text)
		player:hud_change(hud_ids[name].treasures_cnt, "number", color)
	end
end

lzr_gui.set_play_gui = function(player)
	player:hud_set_flags({hotbar=true})
	player:hud_set_hotbar_itemcount(3)
	player:hud_set_hotbar_image("lzr_gui_hotbar_3.png")
	local name = player:get_player_name()
	if hud_ids[name].editor_mode then
		player:hud_remove(hud_ids[name].editor_mode)
		hud_ids[name].editor_mode = nil
	end
	lzr_gui.hide_level_bounds(player)
	lzr_gui.hide_menu_markers(player)
end
lzr_gui.set_editor_gui = function(player)
	player:hud_set_flags({hotbar=true})
	player:hud_set_hotbar_itemcount(8)
	player:hud_set_hotbar_image("lzr_gui_hotbar_8.png")
	local id = player:hud_add({
		hud_elem_type = "text",
		position = { x = 0, y = 1 },
		name = "editor_mode",
		text = S("Level Editor"),
		number = 0xFFFFFF,
		alignment = { x = 1, y = -1 },
		offset = { x = 5, y = -5 },
		scale = { x = 100, y = 100 },
		size = { x = 3, y = 3 },
		z_index = 0,
	})
	local name = player:get_player_name()
	hud_ids[name].editor_mode = id
	lzr_gui.hide_treasure_status(player)
	lzr_gui.hide_menu_markers(player)
end
lzr_gui.show_menu_markers = function(player)
	lzr_gui.hide_menu_markers(player)
	local huds = {}
	local book_offset_hor = 0.1
	local book_offset_ver = -0.15
	local markers = {
		{
			"start",
			S("Start game"),
			vector.offset(vector.add(lzr_globals.MENU_SHIP_POS, lzr_globals.MENU_SHIP_STARTBOOK_OFFSET), 0, book_offset_ver, -book_offset_hor),
		},
		{
			"start_custom",
			S("Custom levels"),
			vector.offset(vector.add(lzr_globals.MENU_SHIP_POS, lzr_globals.MENU_SHIP_CUSTOMBOOK_OFFSET), 0, book_offset_ver, -book_offset_hor),
		},
		{
			"editor",
			S("Level editor"),
			vector.offset(vector.add(lzr_globals.MENU_SHIP_POS, lzr_globals.MENU_SHIP_EDITOR_OFFSET), book_offset_hor, book_offset_ver, 0),
		},
		{
			"ambience",
			S("Ambience"),
			vector.offset(vector.add(lzr_globals.MENU_SHIP_POS, lzr_globals.MENU_SHIP_SPEAKER_OFFSET), 0, 0.75, 0)
		},
	}
	for m=1, #markers do
		local world_pos = markers[m][3]
		local id = player:hud_add({
			hud_elem_type = "waypoint",
			name = markers[m][2],
			precision = 0,
			number = 0xFFFFFF,
			offset = { x = 0, y = -80 },
			scale = { x = 1, y = 1 },
			z_index = -300,
			alignment = { x = 0, y = 0 },
			world_pos = world_pos,
		})
		local id2 = player:hud_add({
			hud_elem_type = "image_waypoint",
			text = "lzr_gui_menu_marker.png",
			offset = { x = 0, y = 0 },
			scale = { x = 6, y = 6 },
			z_index = -300,
			world_pos = world_pos,
		})
		if id then
			table.insert(huds, id)
		end
		if id2 then
			table.insert(huds, id2)
		end
	end
	hud_ids[player:get_player_name()].menu_markers = huds
end
lzr_gui.hide_menu_markers = function(player)
	local name = player:get_player_name()
	if hud_ids[name].menu_markers then
		for m=1, #hud_ids[name].menu_markers do
			player:hud_remove(hud_ids[name].menu_markers[m])
		end
		hud_ids[name].menu_markers = nil
	end
end

lzr_gui.show_level_bounds = function(player, minpos, size)
	lzr_gui.hide_level_bounds(player)
	local maxpos = vector.add(minpos, size)
	local offsets = {
		vector.new(-1, -1, -1),
		vector.new(-1, -1, 1),
		vector.new(-1, 1, -1),
		vector.new(-1, 1, 1),
		vector.new(1, -1, -1),
		vector.new(1, -1, 1),
		vector.new(1, 1, -1),
		vector.new(1, 1, 1),
	}
	local huds = {}
	for o=1, #offsets do
		local offset = offsets[o]
		local corner = vector.zero()
		for _, axis in pairs({"x","y","z"}) do
			if offset[axis] < 0 then
				corner[axis] = minpos[axis] - 0.5
			else
				corner[axis] = maxpos[axis] - 0.5
			end
		end
		local id = player:hud_add({
			hud_elem_type = "image_waypoint",
			name = "editor_level_corner_"..o,
			text = "lzr_gui_level_corner.png",
			precision = 0,
			number = 0xFFFFFF,
			offset = { x = 0, y = 0 },
			scale = { x = 1, y = 1 },
			z_index = -300,
			world_pos = corner,
		})
		if id then
			table.insert(huds, id)
		end
		hud_ids[player:get_player_name()].editor_corners = huds
	end
end
lzr_gui.hide_level_bounds = function(player)
	local name = player:get_player_name()
	if hud_ids[name].editor_corners then
		for c=1, #hud_ids[name].editor_corners do
			player:hud_remove(hud_ids[name].editor_corners[c])
		end
		hud_ids[name].editor_corners = nil
	end
end

lzr_gui.set_menu_gui = function(player)
	player:hud_set_flags({hotbar=false})
	-- Same itemcount as in editor
	-- NOTE: Setting this to 1 might lead to problems!
	player:hud_set_hotbar_itemcount(8)
	local name = player:get_player_name()
	if hud_ids[name].editor_mode then
		player:hud_remove(hud_ids[name].editor_mode)
		hud_ids[name].editor_mode = nil
	end
	lzr_gui.hide_level_bounds(player)
	lzr_gui.show_menu_markers(player)
	lzr_gui.hide_treasure_status(player)
end

minetest.register_on_joinplayer(function(player)
	player:hud_set_flags({minimap = false, minimap_radar = false, healthbar = false, breathbar = false})
	lzr_player.set_menu_inventory(player)
	player:set_formspec_prepend([=[
		listcolors[#5c443280;#a87d5d80;#3b2b2080;#b75647;#ffffff]
		tableoptions[background=#00000030;highlight=#3B6322;border=false]
		background9[0,0;5,5;lzr_gui_bg.png;true;4]
		style_type[button;bgimg=lzr_gui_button.png;bgimg_middle=4]
		style_type[button:hovered;bgimg=lzr_gui_button_hover.png]
		style_type[button:pressed;bgimg=lzr_gui_button_pressed.png]
		style_type[button,image_button,item_image_button;sound=lzr_sounds_button]]=])
	player:hud_set_hotbar_selected_image("lzr_gui_hotbar_selected.png")

	local name = player:get_player_name()
	hud_ids[name] = {}

	lzr_gui.set_menu_gui(player)
end)

minetest.register_on_leaveplayer(function(player)
	local name = player:get_player_name()
	hud_ids[name] = nil
end)
