-- Load support for MT game translation.
local S = minetest.get_translator("lzr_panes")

local HTHICK = 1/16 -- half pane thickness

lzr_panes = {}
function lzr_panes.register_pane(name, def)
	local groups = table.copy(def.groups)
	groups.pane = 1
	groups.laser_block  = 1
	groups.rotatable = 3
	minetest.register_node(":lzr_panes:" .. name .. "_flat", {
		description = def.description,
		drawtype = "nodebox",
		paramtype = "light",
		is_ground_content = false,
		sunlight_propagates = true,
		inventory_image = def.inventory_image,
		wield_image = def.wield_image,
		paramtype2 = "facedir",
		tiles = {
			{ name = def.textures[3], backface_culling = true },
			{ name = def.textures[3], backface_culling = true },
			{ name = def.textures[2], backface_culling = true },
			{ name = def.textures[2], backface_culling = true },
			{ name = def.textures[1], backface_culling = true },
			{ name = def.textures[1], backface_culling = true },
		},
		groups = groups,
		sounds = def.sounds,
		use_texture_alpha = def.use_texture_alpha and "blend" or "clip",
		node_box = {
			type = "fixed",
			fixed = {{-1/2, -1/2, -HTHICK, 1/2, 1/2, HTHICK}},
		},
		selection_box = {
			type = "fixed",
			fixed = {{-1/2, -1/2, -HTHICK, 1/2, 1/2, HTHICK}},
		},
		_after_rotate = function(pos)
			lzr_laser.full_laser_update(lzr_globals.PLAYFIELD_START, lzr_globals.PLAYFIELD_END)
		end,
		_lzr_active = "lzr_panes:"..name.."_flat_on",
	})

	local groups_laser = table.copy(groups)
	groups_laser.not_in_creative_inventory = 1
	minetest.register_node(":lzr_panes:" .. name .. "_flat_on", {
		description = S("@1 with Laser", def.description),
		drawtype = "mesh",
		mesh = "lzr_panes_pane_on.obj",
		paramtype = "light",
		is_ground_content = false,
		sunlight_propagates = true,
		light_source = lzr_globals.LASER_GLOW,
		paramtype2 = "facedir",
		tiles = {
			{ name = def.textures[3], backface_culling = true }, -- top+bottom sides
			{ name = def.textures[2], backface_culling = true }, -- left+right sides
			{ name = def.textures[1], backface_culling = true }, -- front+back
			{ name = "lzr_laser_laser.png", backface_culling = true }, -- laser
		},
		groups = groups_laser,
		sounds = def.sounds,
		use_texture_alpha = "blend",
		node_box = {
			type = "fixed",
			fixed = {{-1/2, -1/2, -HTHICK, 1/2, 1/2, HTHICK}},
		},
		selection_box = {
			type = "fixed",
			fixed = {{-1/2, -1/2, -HTHICK, 1/2, 1/2, HTHICK}},
		},
		drop = "lzr_panes:"..name.."_flat",
		_after_rotate = function(pos)
			-- Victory check not needed becaus
			lzr_laser.full_laser_update(lzr_globals.PLAYFIELD_START, lzr_globals.PLAYFIELD_END)
		end,
		_lzr_inactive = "lzr_panes:"..name.."_flat",
	})
end

lzr_panes.register_pane("bar", {
	description = S("Iron Bars"),
	textures = {"lzr_panes_bar.png", "lzr_panes_bar_top.png", "lzr_panes_bar_top.png"},
	inventory_image = "lzr_panes_bar.png",
	wield_image = "lzr_panes_bar.png",
	sounds = lzr_sounds.node_sound_metal_defaults(),
	groups = {breakable = 1},
})
lzr_panes.register_pane("grate", {
	description = S("Iron Grate"),
	textures = {"lzr_panes_grate.png", "lzr_panes_bar_top.png", "lzr_panes_bar_top.png"},
	inventory_image = "lzr_panes_grate.png",
	wield_image = "lzr_panes_grate.png",
	sounds = lzr_sounds.node_sound_metal_defaults(),
	groups = {breakable = 1},
})

