local S = minetest.get_translator("lzr_player")
local F = minetest.formspec_escape

lzr_player = {}

lzr_player.set_play_inventory = function(player)
	local inv = player:get_inventory()
	inv:set_size("main", 3)
	player:set_inventory_formspec(
		"formspec_version[4]size[11,6.4]label[0.5,0.5;"..F(S("Inventory")).."]list[current_player;main;0.5,0.9;3,1]"
	)
end
lzr_player.set_editor_inventory = function(player)
	local inv = player:get_inventory()
	inv:set_size("main", 32)
	player:set_inventory_formspec(
		"formspec_version[4]size[11,8.3]label[0.5,0.5;"..F(S("Inventory")).."]list[current_player;main;0.5,0.9;8,4]"..
		"button[7.25,0.2;3,0.6;__lzr_level_editor_get_item;"..F(S("Get items")).."]"..
		"box[0.5,5.9;9.7,2.1;#00000080]"..
		"label[0.6,6.15;"..F(S("Level editor")).."]"..
		"button_exit[0.6,6.5;4.6,0.6;__lzr_level_editor_exit;"..F(S("Exit")).."]"..
		"button[5.5,6.5;4.6,0.6;__lzr_level_editor_settings;"..F(S("Level settings")).."]"..
		"button[0.6,7.3;4.6,0.6;__lzr_level_editor_save;"..F(S("Save level")).."]"..
		"button[5.5,7.3;4.6,0.6;__lzr_level_editor_load;"..F(S("Load level")).."]"
	)
	-- NOTE: Event handling in lzr_editor
end
lzr_player.set_menu_inventory = function(player)
	local inv = player:get_inventory()
	inv:set_size("main", 3)
	player:set_inventory_formspec("")
end

minetest.register_on_joinplayer(function(player)
	local inv = player:get_inventory()
	inv:set_size("craft", 0)
	lzr_sky.set_sky(lzr_globals.DEFAULT_SKY)

	lzr_player.set_menu_inventory(player)
end)

-- Can't drop items
function minetest.item_drop(itemstack, dropper, pos)
	if lzr_gamestate.get_state() == lzr_gamestate.EDITOR then
		-- Destroy item in editor mode
		return ""
	else
		return itemstack
	end
end
