-- This mod disallows changing blocks in certain game modes.
-- In Editor mode, out-of-bounds blocks cannot be changed.
-- This can be bypassed with the server or protection_bypass privileges.

local old_is_protected = minetest.is_protected

minetest.is_protected = function(pos, name)
	if minetest.check_player_privs(name, { server = true, protection_bypass = true }) then
		return false
	end
	local state = lzr_gamestate.get_state()
	if state == lzr_gamestate.LEVEL_COMPLETE or state == lzr_gamestate.MENU then
		return true
	elseif state == lzr_gamestate.EDITOR then
		return not lzr_editor.is_in_level_bounds(pos)
	end
	return old_is_protected(pos, name)
end
