local S = minetest.get_translator("lzr_core")

minetest.register_node("lzr_core:stone", {
	description = S("Stone"),
	tiles = {"default_stone.png"},
	groups = { breakable = 1 },
	sounds = lzr_sounds.node_sound_stone_defaults(),
})

minetest.register_node("lzr_core:seabed", {
	description = S("Seabed"),
	tiles = {"lzr_core_seabed.png"},
	groups = { breakable = 1 },
	sounds = lzr_sounds.node_sound_sand_defaults(),
})

minetest.register_node("lzr_core:sand", {
	description = S("Sand"),
	tiles = {"default_sand.png"},
	groups = { breakable = 1 },
	sounds = lzr_sounds.node_sound_sand_defaults(),
})

minetest.register_node("lzr_core:dirt", {
	description = S("Dirt"),
	tiles = {"default_dirt.png"},
	groups = { breakable = 1 },
	sounds = lzr_sounds.node_sound_dirt_defaults(),
})

minetest.register_node("lzr_core:dirt_with_grass", {
	description = S("Dirt with Grass"),
	tiles = {"default_grass.png", "default_dirt.png",
		{name = "default_dirt.png^default_grass_side.png", tileable_vertical = false}},
	groups = { breakable = 1 },
	sounds = lzr_sounds.node_sound_dirt_defaults(),
})

minetest.register_node("lzr_core:dirt_with_jungle_litter", {
	description = S("Dirt with Jungle Litter"),
	tiles = {"default_rainforest_litter.png", "default_dirt.png",
		{name = "default_dirt.png^default_rainforest_litter_side.png", tileable_vertical = false}},
	groups = { breakable = 1 },
	sounds = lzr_sounds.node_sound_dirt_defaults(),
})

minetest.register_node("lzr_core:shrub_leaves", {
	description = S("Shrub Leaves"),
	paramtype = "light",
	drawtype = "allfaces",
	tiles = {"lzr_core_shrub_leaves.png"},
	use_texture_alpha = "clip",
	groups = { breakable = 1 },
	sounds = lzr_sounds.node_sound_leaves_defaults(),
	is_ground_content = false,
})

local lb = 0.499 --leaves border
minetest.register_node("lzr_core:bright_palm_leaves", {
	description = S("Bright Palm Leaves"),
	paramtype = "light",
	drawtype = "nodebox",
	collision_box = {
		type = "fixed",
		fixed = { -0.5, -0.5, -0.5, 0.5, 0.5, 0.5 },
	},
	node_box = {
		type = "fixed",
		fixed = { -lb, -0.5, -lb, lb, lb, lb },
	},
	tiles = {
		{name="lzr_core_palm_leaves_top.png",backface_culling = false},
		{name="blank.png"},
		{name="lzr_core_palm_leaves.png",backface_culling = false},
	},
	use_texture_alpha = "clip",
	groups = { breakable = 1 },
	sounds = lzr_sounds.node_sound_leaves_defaults(),
	is_ground_content = false,
})

minetest.register_node("lzr_core:dark_palm_leaves", {
	description = S("Dark Palm Leaves"),
	paramtype = "light",
	drawtype = "nodebox",
	collision_box = {
		type = "fixed",
		fixed = { -0.5, -0.5, -0.5, 0.5, 0.5, 0.5 },
	},
	node_box = {
		type = "fixed",
		fixed = { -lb, -0.5, -lb, lb, lb, lb },
	},
	tiles = {
		{name="lzr_core_palm_leaves_top.png",backface_culling = false},
		{name="blank.png"},
		{name="lzr_core_palm_leaves.png",backface_culling = false},
	},
	color = "#00B000",
	use_texture_alpha = "clip",
	groups = { breakable = 1 },
	sounds = lzr_sounds.node_sound_leaves_defaults(),
	is_ground_content = false,
})

minetest.register_node("lzr_core:tree", {
	description = S("Tree Trunk"),
	tiles = {"default_tree_top.png", "default_tree_top.png", "default_tree.png"},
	paramtype2 = "facedir",
	is_ground_content = false,
	groups = { breakable = 1, rotatable = 3 },
	sounds = lzr_sounds.node_sound_wood_defaults(),

	on_place = minetest.rotate_node
})

minetest.register_node("lzr_core:palm_tree", {
	description = S("Palm Tree Trunk"),
	tiles = {"lzr_core_palm_tree_top.png", "lzr_core_palm_tree_top.png", "lzr_core_palm_tree.png"},
	paramtype2 = "facedir",
	is_ground_content = false,
	groups = { breakable = 1, rotatable = 3 },
	sounds = lzr_sounds.node_sound_wood_defaults(),

	on_place = minetest.rotate_node
})

minetest.register_node("lzr_core:coconut_tree", {
	description = S("Coconut Tree Trunk"),
	tiles = {"coconut_tree_top.png", "coconut_tree_top.png", "coconut_tree.png"},
	paramtype2 = "facedir",
	is_ground_content = false,
	groups = { breakable = 1, rotatable = 3 },
	sounds = lzr_sounds.node_sound_wood_defaults(),

	on_place = minetest.rotate_node
})

minetest.register_node("lzr_core:coconut", {
	description = S("Coconut"),
	paramtype2 = "facedir",
	tiles = {"coconut_top.png","coconut.png"},
	groups = { breakable = 1, rotatable = 3 },
	sounds = lzr_sounds.node_sound_wood_defaults(),
})

minetest.register_node("lzr_core:wood", {
	description = S("Wood Planks"),
	tiles = {"default_wood.png"},
	is_ground_content = false,
	groups = { breakable = 1 },
	sounds = lzr_sounds.node_sound_wood_defaults(),
})

minetest.register_node("lzr_core:wood_mossy", {
	description = S("Mossy Wood Planks"),
	tiles = {"lzr_core_wood_mossy.png"},
	is_ground_content = false,
	groups = { breakable = 1 },
	sounds = lzr_sounds.node_sound_wood_defaults(),
})



minetest.register_node("lzr_core:palm_wood", {
	description = S("Palm Wood Planks"),
	tiles = {"lzr_core_palm_wood.png"},
	is_ground_content = false,
	groups = { breakable = 1 },
	sounds = lzr_sounds.node_sound_wood_defaults(),
})

minetest.register_node("lzr_core:coconut_wood", {
	description = S("Coconut Wood Planks"),
	tiles = {"lzr_core_coconut_wood.png"},
	is_ground_content = false,
	groups = { breakable = 1 },
	sounds = lzr_sounds.node_sound_wood_defaults(),
})

minetest.register_node("lzr_core:water_source", {
	description = S("Water Source"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "default_water_source_animated.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "default_water_source_animated.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	buildable_to = false,
	is_ground_content = false,
	liquidtype = "source",
	liquid_alternative_flowing = "lzr_core:water_source",
	liquid_alternative_source = "lzr_core:water_source",
	liquid_viscosity = 1,
	liquid_range = 0,
	liquid_renewable = false,
	liquids_pointable = true,
	post_effect_color = {a = 192, r = 17, g = 69, b = 135},
	groups = {water = 3, liquid = 3},
})

-- For invisible level borders
minetest.register_node("lzr_core:barrier", {
	description = S("Barrier"),
	drawtype = "airlike",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = true,
	wield_image = "lzr_core_barrier.png",
	inventory_image = "lzr_core_barrier.png",
	groups = { breakable = 1, not_in_creative_inventory = 1 },
	is_ground_content = false,

	-- Prevent building things on the barrier
	on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
		return itemstack
	end,
})

-- Rain membrane corner position
local RMC = 0.25
-- Rain membrane offset (a tiny value);
-- determines the X/Z size of the columns
local RMO = 0.01

-- HACK: A node that lets rain through (mostly)
-- but not the player. This node can be used as a
-- level ceiling for rainy levels.
minetest.register_node("lzr_core:rain_membrane", {
	description = S("Rain Membrane"),
	drawtype = "airlike",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = true,
	wield_image = "lzr_core_rain_membrane.png",
	inventory_image = "lzr_core_rain_membrane.png",
	groups = { breakable = 1, not_in_creative_inventory = 1 },
	-- The collision box is made of 4 very thin columns,
	-- equally spaced apart. This is enough to prevent the player
	-- from moving through it vertically, assuming the player collisionbox is
	-- larger than the space between the columns (which is roughly
	-- RMO times 2).
	-- Because the columns are so thin, they leave enough space
	-- for most rain particles to go through, except for the few unlucky ones
	-- that directly hit the columns (but this is rare).
	collision_box = {
		type = "fixed",
		fixed = {
			{ -RMC-RMO, -0.5, -RMC-RMO, -RMC+RMO, 0.5, -RMC+RMO }, -- (-1,-1)
			{ -RMC-RMO, -0.5,  RMC-RMO, -RMC+RMO, 0.5,  RMC+RMO }, -- (-1, 1)
			{  RMC-RMO, -0.5, -RMC-RMO,  RMC+RMO, 0.5, -RMC+RMO }, -- ( 1,-1)
			{  RMC-RMO, -0.5,  RMC-RMO,  RMC+RMO, 0.5,  RMC+RMO }, -- ( 1, 1)
		},
	},
	selection_box = {
		type = "regular",
	},
	is_ground_content = false,

	-- Prevent building things on the rain membrane
	on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
		return itemstack
	end,
})

